/*
 * Decompiled with CFR 0.152.
 */
package de.openknowledge.cdi.common.property;

import de.openknowledge.cdi.common.property.ApplicationProperties;
import de.openknowledge.cdi.common.property.Property;
import de.openknowledge.cdi.common.property.source.PropertyProvider;
import de.openknowledge.cdi.common.qualifier.Current;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.Properties;
import javax.enterprise.context.ApplicationScoped;
import javax.enterprise.inject.Produces;
import javax.enterprise.inject.spi.InjectionPoint;
import javax.inject.Inject;
import org.apache.commons.lang.ClassUtils;

@ApplicationScoped
public class PropertiesLoader {
    @Inject
    @Current
    private ApplicationProperties currentValues = new ApplicationProperties();
    @Inject
    private PropertyProvider provider;

    @Produces
    @Property(name="any")
    public Properties produceWildcardProperties(InjectionPoint injectionPoint) {
        return this.provider.getPropertyValues(injectionPoint);
    }

    @Produces
    @Property(name="any")
    public Object produceProperty(InjectionPoint injectionPoint) {
        Class<?> type = PropertiesLoader.toClass(injectionPoint.getType());
        return this.newInstance(injectionPoint, this.getPropertyValue(injectionPoint, type), ClassUtils.primitiveToWrapper(type));
    }

    @Produces
    @Property(name="any")
    public Character produceCharacterProperty(InjectionPoint injectionPoint) {
        Class<?> type = PropertiesLoader.toClass(injectionPoint.getType());
        String value = this.getPropertyValue(injectionPoint, type);
        if (value.length() != 1) {
            throw this.buildIllegalArgumentException(injectionPoint, value, type, null);
        }
        return Character.valueOf(value.charAt(0));
    }

    protected String getPropertyValue(InjectionPoint injectionPoint, Class<?> targetType) {
        String value = this.provider.getPropertyValue(injectionPoint);
        this.assertPrimitiveNotNull(injectionPoint, value, targetType);
        this.currentValues.registerPropertyValue(injectionPoint, value);
        return value;
    }

    static Class<?> toClass(Type type) {
        if (type instanceof Class) {
            return (Class)type;
        }
        if (type instanceof ParameterizedType) {
            return PropertiesLoader.toClass(((ParameterizedType)type).getRawType());
        }
        throw new IllegalArgumentException("unsupported type for property injection: " + type);
    }

    private <T> T newInstance(InjectionPoint injectionPoint, String value, Class<T> type) {
        if (value == null) {
            return null;
        }
        try {
            return type.getConstructor(String.class).newInstance(value);
        }
        catch (NoSuchMethodException e) {
            throw new IllegalArgumentException(type.getName() + " must have String-constructor to be injected");
        }
        catch (IllegalAccessException e) {
            throw new IllegalArgumentException("String-constructor must be public");
        }
        catch (InstantiationException e) {
            throw this.buildIllegalArgumentException(injectionPoint, value, type, e);
        }
        catch (InvocationTargetException e) {
            throw this.buildIllegalArgumentException(injectionPoint, value, type, e.getTargetException());
        }
    }

    private void assertPrimitiveNotNull(InjectionPoint injectionPoint, String value, Class<?> expectedType) {
        if (expectedType.isPrimitive() && value == null) {
            throw this.buildIllegalArgumentException(injectionPoint, value, expectedType, null);
        }
    }

    private RuntimeException buildIllegalArgumentException(InjectionPoint injectionPoint, String value, Class<?> expectedType, Throwable cause) {
        StringBuilder messageBuilder = new StringBuilder();
        messageBuilder.append("Unable to convert ");
        if (value == null) {
            messageBuilder.append("null value");
        } else {
            messageBuilder.append('\"').append(value).append('\"');
        }
        messageBuilder.append(" to ").append(expectedType.getName());
        messageBuilder.append(" for injection point ").append(injectionPoint);
        return new IllegalArgumentException(messageBuilder.toString(), cause);
    }
}

