/*
 * Decompiled with CFR 0.152.
 */
package de.openknowledge.cdi.common.property;

import de.openknowledge.cdi.common.property.PropertiesLoader;
import de.openknowledge.cdi.common.property.Property;
import de.openknowledge.cdi.common.spi.DelegatingBean;
import java.lang.annotation.Annotation;
import java.lang.reflect.Constructor;
import java.lang.reflect.Type;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import javax.enterprise.event.Observes;
import javax.enterprise.inject.spi.AfterBeanDiscovery;
import javax.enterprise.inject.spi.Annotated;
import javax.enterprise.inject.spi.AnnotatedConstructor;
import javax.enterprise.inject.spi.AnnotatedField;
import javax.enterprise.inject.spi.AnnotatedMethod;
import javax.enterprise.inject.spi.AnnotatedParameter;
import javax.enterprise.inject.spi.AnnotatedType;
import javax.enterprise.inject.spi.Bean;
import javax.enterprise.inject.spi.Extension;
import javax.enterprise.inject.spi.ProcessAnnotatedType;
import javax.enterprise.inject.spi.ProcessBean;
import org.apache.commons.lang.ClassUtils;
import org.apache.commons.lang.Validate;

public class PropertiesLoaderExtension
implements Extension {
    private Set<Class<?>> customTypes = new HashSet();
    private Bean<?> producePropertyBean;

    public <T> void registerCustomTypes(@Observes ProcessAnnotatedType<T> annotatedTypeEvent) {
        AnnotatedType annotatedType = annotatedTypeEvent.getAnnotatedType();
        this.registerCustomType(annotatedType);
    }

    public void registerProducePropertyBean(@Observes ProcessBean<?> processBeanEvent) {
        Bean bean = processBeanEvent.getBean();
        if (this.isProducePropertyBean(bean)) {
            this.producePropertyBean = bean;
        }
    }

    public void addBeans(@Observes AfterBeanDiscovery afterBeanDiscoveryEvent) {
        for (Class<?> customType : this.customTypes) {
            afterBeanDiscoveryEvent.addBean(this.createProducePropertyBean(this.producePropertyBean, customType));
        }
    }

    private void registerCustomType(AnnotatedType<?> annotatedType) {
        for (AnnotatedField field : annotatedType.getFields()) {
            if (!PropertiesLoaderExtension.isPropertyInjectionPoint((Annotated)field)) continue;
            this.customTypes.add(ClassUtils.primitiveToWrapper(PropertiesLoader.toClass(field.getBaseType())));
        }
        for (AnnotatedMethod method : annotatedType.getMethods()) {
            for (AnnotatedParameter parameter : method.getParameters()) {
                if (!PropertiesLoaderExtension.isPropertyInjectionPoint((Annotated)parameter)) continue;
                this.customTypes.add(ClassUtils.primitiveToWrapper(PropertiesLoader.toClass(parameter.getBaseType())));
            }
        }
        for (AnnotatedConstructor constructor : annotatedType.getConstructors()) {
            for (AnnotatedParameter parameter : constructor.getParameters()) {
                if (!PropertiesLoaderExtension.isPropertyInjectionPoint((Annotated)parameter)) continue;
                this.customTypes.add(ClassUtils.primitiveToWrapper(PropertiesLoader.toClass(parameter.getBaseType())));
            }
        }
    }

    private static boolean isPropertyInjectionPoint(Annotated annotated) {
        return annotated.isAnnotationPresent(Property.class) && PropertiesLoaderExtension.isStringConstructorPresent(annotated.getBaseType());
    }

    private static boolean isStringConstructorPresent(Type type) {
        for (Constructor<?> constructor : ClassUtils.primitiveToWrapper(PropertiesLoader.toClass(type)).getConstructors()) {
            Class<?>[] parameterTypes = constructor.getParameterTypes();
            if (parameterTypes.length != 1 || !String.class.equals(parameterTypes[0])) continue;
            return true;
        }
        return false;
    }

    private boolean isProducePropertyBean(Bean<?> bean) {
        if (bean.getTypes().size() > 1) {
            return false;
        }
        if (!bean.getTypes().contains(Object.class)) {
            return false;
        }
        for (Annotation annotation : bean.getQualifiers()) {
            if (!annotation.annotationType().equals(Property.class)) continue;
            return true;
        }
        return false;
    }

    private <T> Bean<T> createProducePropertyBean(Bean<T> bean, Class<?> type) {
        return new ProducePropertyBean<T>(bean, type);
    }

    private class ProducePropertyBean<T>
    extends DelegatingBean<T> {
        private Class<?> type;

        public ProducePropertyBean(Bean<T> delegateBean, Class<?> type) {
            super(delegateBean);
            Validate.notNull(type);
            this.type = type;
        }

        @Override
        public Set<Type> getTypes() {
            return Collections.singleton(this.type);
        }

        @Override
        public boolean isNullable() {
            if (this.isWrapperType()) {
                return false;
            }
            return super.isNullable();
        }

        private boolean isWrapperType() {
            return ClassUtils.wrapperToPrimitive(this.type) != null;
        }
    }
}

