/*
 * Decompiled with CFR 0.152.
 */
package de.openknowledge.cdi.common.property.source;

import de.openknowledge.cdi.common.annotation.Order;
import de.openknowledge.cdi.common.property.Property;
import de.openknowledge.cdi.common.property.PropertySource;
import de.openknowledge.cdi.common.property.source.PropertyProvider;
import de.openknowledge.cdi.common.property.source.PropertySourceLoader;
import java.beans.Introspector;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.ConcurrentHashMap;
import javax.annotation.PostConstruct;
import javax.enterprise.inject.Any;
import javax.enterprise.inject.Instance;
import javax.enterprise.inject.spi.InjectionPoint;
import javax.inject.Inject;

public class DefaultPropertyProvider
implements PropertyProvider {
    public static final String PROPERTIES_FILE_EXTENSION = ".properties";
    public static final String CLASSPATH_SCHEME = "classpath";
    @Inject
    @Any
    private Instance<PropertySourceLoader> supportedSources;
    private Map<URI, Properties> properties = new ConcurrentHashMap<URI, Properties>();
    private Map<InjectionPoint, URI> sourceNameMap = new ConcurrentHashMap<InjectionPoint, URI>();
    private List<PropertySourceLoader> sourceLoaders = new ArrayList<PropertySourceLoader>();

    @Override
    public String getPropertyValue(InjectionPoint injectionPoint) {
        Property property = (Property)injectionPoint.getAnnotated().getAnnotation(Property.class);
        Properties properties = this.getProperties(this.getSource(injectionPoint, property));
        return properties.getProperty(property.name(), this.getDefaultValue(properties, property));
    }

    @Override
    public Properties getPropertyValues(InjectionPoint wildCard) {
        Property property = (Property)wildCard.getAnnotated().getAnnotation(Property.class);
        String wildcardName = property.name();
        if (!wildcardName.endsWith("*")) {
            throw new IllegalArgumentException("You need to specify a wildcard to access properties. Missing wildcard in " + wildcardName);
        }
        URI source = this.getSource(wildCard, property);
        Properties p = new Properties();
        if (source != null) {
            String keyPrefix = wildcardName.substring(0, wildcardName.length() - 1);
            Properties allProperties = this.getProperties(source);
            for (Object o : allProperties.keySet()) {
                if (!String.valueOf(o).startsWith(keyPrefix)) continue;
                p.put(o, allProperties.get(o));
            }
        }
        return p;
    }

    protected String getDefaultValue(Properties properties, Property property) {
        if (property.defaultValue().length() == 0) {
            return null;
        }
        return this.expandPropertyValue(properties, property.defaultValue());
    }

    protected URI getSource(InjectionPoint aInjectionPoint, Property property) {
        if (this.sourceNameMap.containsKey(aInjectionPoint)) {
            return this.sourceNameMap.get(aInjectionPoint);
        }
        URI source = this.extractSource(aInjectionPoint, property);
        if (source != null) {
            this.sourceNameMap.put(aInjectionPoint, source);
        }
        return source;
    }

    protected URI extractSource(InjectionPoint injectionPoint, Property property) {
        URI propertySource = this.extractFromProperty(injectionPoint, property);
        if (propertySource != null) {
            return propertySource;
        }
        URI classSource = this.extractSourceFromClass(injectionPoint.getBean().getBeanClass());
        if (classSource != null) {
            return classSource;
        }
        URI packageSource = this.extractSourceFromPackage(injectionPoint.getBean().getBeanClass().getPackage().getName());
        if (packageSource != null) {
            return packageSource;
        }
        return this.extractDefaultSource(injectionPoint.getBean().getBeanClass());
    }

    protected URI extractFromProperty(InjectionPoint injectionPoint, Property property) {
        if (property.source().length() == 0) {
            return null;
        }
        return this.toUri(injectionPoint.getBean().getBeanClass().getPackage(), property.source());
    }

    protected URI extractSourceFromClass(Class<?> beanClass) {
        if (!beanClass.isAnnotationPresent(PropertySource.class)) {
            return null;
        }
        return this.toUri(beanClass.getPackage(), beanClass.getAnnotation(PropertySource.class).value());
    }

    protected URI extractSourceFromPackage(String packageName) {
        Package pkg = Package.getPackage(packageName);
        if (pkg != null && pkg.isAnnotationPresent(PropertySource.class)) {
            return this.toUri(pkg, pkg.getAnnotation(PropertySource.class).value());
        }
        int index = packageName.lastIndexOf(46);
        if (index > 0) {
            return this.extractSourceFromPackage(packageName.substring(0, index));
        }
        return null;
    }

    protected URI extractDefaultSource(Class<?> beanClass) {
        String defaultName = Introspector.decapitalize(beanClass.getSimpleName()) + PROPERTIES_FILE_EXTENSION;
        return this.toUri(beanClass.getPackage(), defaultName);
    }

    protected URI toUri(Package pkg, String source) {
        source = this.expandSourceSystemProperties(source);
        try {
            URI uri = new URI(source);
            if (uri.getScheme() != null && !CLASSPATH_SCHEME.equals(uri.getScheme())) {
                return uri;
            }
            return new URI(uri.getScheme(), uri.getUserInfo(), uri.getHost(), uri.getPort(), this.resolve(pkg, uri.getPath()), uri.getQuery(), uri.getFragment());
        }
        catch (URISyntaxException e) {
            throw new IllegalArgumentException(e);
        }
    }

    protected String resolve(Package pkg, String path) {
        if (this.isAbsolute(path)) {
            return path;
        }
        String packageName = pkg.getName();
        int capacity = packageName.length() + path.length() + 2;
        StringBuilder pathBuilder = new StringBuilder(capacity);
        pathBuilder.append('/');
        pathBuilder.append(packageName.replace('.', '/'));
        pathBuilder.append('/');
        pathBuilder.append(path);
        return pathBuilder.toString();
    }

    protected boolean isAbsolute(String source) {
        return source.charAt(0) == '/';
    }

    protected Properties getProperties(URI source) {
        Properties p = this.properties.get(source);
        return p != null ? p : this.loadPropertiesFromLoader(source);
    }

    protected synchronized Properties loadPropertiesFromLoader(URI source) {
        for (PropertySourceLoader sourceLoader : this.sourceLoaders) {
            if (!sourceLoader.supports(source)) continue;
            Properties p = sourceLoader.load(source);
            for (Object key : p.keySet()) {
                p.put(key, this.expandPropertyValue(p, String.valueOf(p.get(key))));
            }
            this.properties.put(source, p);
            return p;
        }
        throw new IllegalArgumentException("Unsupported source reference " + source);
    }

    protected String expandSourceSystemProperties(String value) {
        int last;
        int i = value.indexOf("${");
        if (i > 0 && (last = value.indexOf("}", i)) > 0) {
            String placeholder = value.substring(i + 2, last);
            value = value.substring(0, i) + this.replaceSourceSystemProperty(placeholder) + value.substring(last + 1);
            return this.expandSourceSystemProperties(value);
        }
        return value;
    }

    protected String replaceSourceSystemProperty(String placeHolder) {
        Object value = System.getProperties().get(placeHolder);
        if (value == null) {
            return "!" + placeHolder + "!";
        }
        return String.valueOf(value);
    }

    protected String expandPropertyValue(Properties p, String value) {
        int last;
        int i = value.indexOf("${");
        if (i >= 0 && (last = value.indexOf("}", i)) > 0) {
            String placeholder = value.substring(i + 2, last);
            value = value.substring(0, i) + this.replaceProperty(p, placeholder) + value.substring(last + 1);
            return this.expandPropertyValue(p, value);
        }
        return value;
    }

    protected String replaceProperty(Properties p, String placeHolder) {
        Object value = p.get(placeHolder);
        if (value == null) {
            value = System.getProperties().get(placeHolder);
        }
        if (value == null) {
            return "!" + placeHolder + "!";
        }
        return String.valueOf(value);
    }

    @PostConstruct
    protected void init() {
        ArrayList<PropertySourceLoader> unsorted = new ArrayList<PropertySourceLoader>();
        for (PropertySourceLoader newSourceLoader : this.supportedSources) {
            Order newLoaderOrderAnnotation = newSourceLoader.getClass().getAnnotation(Order.class);
            if (newLoaderOrderAnnotation != null) {
                int newLoaderOrder = newLoaderOrderAnnotation.value();
                boolean added = false;
                for (int i = 0; i < this.sourceLoaders.size(); ++i) {
                    Order currentLoaderAnnotation = this.sourceLoaders.get(i).getClass().getAnnotation(Order.class);
                    if (newLoaderOrder > currentLoaderAnnotation.value()) continue;
                    this.sourceLoaders.add(i, newSourceLoader);
                    added = true;
                    break;
                }
                if (added) continue;
                this.sourceLoaders.add(newSourceLoader);
                continue;
            }
            unsorted.add(0, newSourceLoader);
        }
        this.sourceLoaders.addAll(0, unsorted);
    }
}

