/*
 * Copyright open knowledge GmbH
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *  http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package de.openknowledge.cdi.common.property.source;

import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.util.Properties;

/**
 * @author Jens Schumann - open knowledge GmbH
 * @author Arne Limburg - open knowledge GmbH
 * @version $Revision: 7659 $
 */
public abstract class AbstractPropertySourceLoader implements PropertySourceLoader {

  public URI resolve(Package pkg, URI resource) {
    return resource;
  }

  public void loadFromStream(Properties properties, InputStream inputStream) throws IOException {
    if (inputStream == null) {
      throw new NullPointerException("Inputstream may not be null");
    }
    try {
      properties.load(inputStream);
    } finally {
      try {
        inputStream.close();
      } catch (IOException e) {
        // ignored
      }
    }
  }
}
