/*
 * Decompiled with CFR 0.152.
 */
package de.openknowledge.cdi.common.property;

import de.openknowledge.cdi.common.property.ApplicationProperties;
import de.openknowledge.cdi.common.property.Property;
import de.openknowledge.cdi.common.qualifier.Current;
import de.openknowledge.cdi.common.spi.SingletonBean;
import java.lang.annotation.Annotation;
import java.util.List;
import java.util.Set;
import javax.enterprise.event.Observes;
import javax.enterprise.inject.spi.AfterBeanDiscovery;
import javax.enterprise.inject.spi.AnnotatedConstructor;
import javax.enterprise.inject.spi.AnnotatedField;
import javax.enterprise.inject.spi.AnnotatedMethod;
import javax.enterprise.inject.spi.AnnotatedParameter;
import javax.enterprise.inject.spi.AnnotatedType;
import javax.enterprise.inject.spi.Bean;
import javax.enterprise.inject.spi.BeanManager;
import javax.enterprise.inject.spi.Extension;
import javax.enterprise.inject.spi.ProcessAnnotatedType;
import javax.enterprise.util.AnnotationLiteral;

public class ApplicationPropertiesExtension
implements Extension {
    private ApplicationProperties properties = new ApplicationProperties();

    public void recordProperty(@Observes ProcessAnnotatedType event) {
        AnnotatedType annotatedType = event.getAnnotatedType();
        Set fields = annotatedType.getFields();
        for (AnnotatedField f : fields) {
            if (!f.isAnnotationPresent(Property.class)) continue;
            Property annotation = (Property)f.getAnnotation(Property.class);
            this.properties.addProperty(annotation);
        }
        Set methods = annotatedType.getMethods();
        for (AnnotatedMethod method : methods) {
            List params = method.getParameters();
            this.parseParameters(params);
        }
        Set constructors = annotatedType.getConstructors();
        for (AnnotatedConstructor constructor : constructors) {
            List params = constructor.getParameters();
            this.parseParameters(params);
        }
    }

    public void publishApplicationProperties(@Observes AfterBeanDiscovery event, BeanManager bm) {
        event.addBean((Bean)new SingletonBean("__ext_applicationProperties", (Object)this.properties, bm, new Annotation[]{new AnnotationLiteral<Current>(){}}));
    }

    private void parseParameters(List<AnnotatedParameter> aParams) {
        for (AnnotatedParameter param : aParams) {
            if (!param.isAnnotationPresent(Property.class)) continue;
            this.properties.addProperty((Property)param.getAnnotation(Property.class));
        }
    }
}

