/*
 * Decompiled with CFR 0.152.
 */
package de.openknowledge.cdi.common.property.source;

import de.openknowledge.cdi.common.property.source.AbstractPropertySourceLoader;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.util.Properties;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class ClassPathPropertySourceLoader
extends AbstractPropertySourceLoader {
    public static final String CLASSPATH_SCHEME = "classpath";
    private static final Log LOG = LogFactory.getLog(ClassPathPropertySourceLoader.class);

    @Override
    public boolean supports(URI source) {
        return source.getScheme() == null || CLASSPATH_SCHEME.equals(source.getScheme());
    }

    @Override
    public Properties load(URI resource) {
        Properties properties = new Properties();
        try {
            String resourceName = resource.getPath().substring(1);
            InputStream stream = Thread.currentThread().getContextClassLoader().getResourceAsStream(resourceName);
            if (stream == null) {
                LOG.warn((Object)("Property file " + resource + " not found in classpath."));
            } else {
                LOG.debug((Object)("Loading properties from classpath " + resource));
                this.loadFromStream(properties, stream);
            }
        }
        catch (IOException e) {
            LOG.warn((Object)("Error loading properties from classpath resource " + resource + ": " + e.getMessage()));
        }
        return properties;
    }
}

