/*
 * Decompiled with CFR 0.152.
 */
package de.openknowledge.cdi.common.spi;

import de.openknowledge.cdi.common.spi.NamedLiteral;
import java.lang.annotation.Annotation;
import java.lang.reflect.Type;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import javax.enterprise.context.Dependent;
import javax.enterprise.inject.Any;
import javax.enterprise.inject.Default;
import javax.enterprise.inject.spi.AnnotatedType;
import javax.enterprise.inject.spi.Bean;
import javax.enterprise.inject.spi.BeanManager;
import javax.enterprise.inject.spi.InjectionPoint;
import javax.enterprise.inject.spi.PassivationCapable;
import javax.enterprise.util.AnnotationLiteral;
import javax.inject.Named;

public abstract class AbstractCdiBean<T>
implements PassivationCapable,
Bean<T> {
    private String beanName;
    private Class<?> beanClass;
    private Set<Type> beanTypes;
    private Set<Annotation> qualifiers;
    private Set<Class<? extends Annotation>> stereotypes;
    private Class<? extends Annotation> scope = Dependent.class;

    public AbstractCdiBean(String name, Class<?> type, BeanManager beanManager, Annotation ... additionalQualifiers) {
        this.beanName = name;
        this.beanClass = type;
        AnnotatedType annotatedType = beanManager.createAnnotatedType(type);
        Set beanTypes = annotatedType.getTypeClosure();
        HashSet<Object> qualifiers = new HashSet<Object>();
        HashSet<Class<? extends Annotation>> stereotypes = new HashSet<Class<? extends Annotation>>();
        for (Annotation annotation : annotatedType.getAnnotations()) {
            if (beanManager.isQualifier(annotation.annotationType()) && !Named.class.equals(annotation.annotationType())) {
                qualifiers.add(annotation);
            }
            if (!beanManager.isStereotype(annotation.annotationType())) continue;
            stereotypes.add(annotation.annotationType());
        }
        for (Annotation qualifier : additionalQualifiers) {
            qualifiers.add(qualifier);
        }
        qualifiers.add(new AnnotationLiteral<Any>(){});
        if (qualifiers.size() == 1) {
            qualifiers.add(new AnnotationLiteral<Default>(){});
        }
        if (name != null) {
            qualifiers.add((Object)new NamedLiteral(name));
        }
        this.beanTypes = Collections.unmodifiableSet(beanTypes);
        this.qualifiers = Collections.unmodifiableSet(qualifiers);
        this.stereotypes = Collections.unmodifiableSet(stereotypes);
    }

    public String getId() {
        return this.beanClass.getName() + "@" + System.identityHashCode(this);
    }

    public String getName() {
        return this.beanName;
    }

    public Class<?> getBeanClass() {
        return this.beanClass;
    }

    public Set<Type> getTypes() {
        return this.beanTypes;
    }

    public Set<Annotation> getQualifiers() {
        return this.qualifiers;
    }

    public Set<Class<? extends Annotation>> getStereotypes() {
        return this.stereotypes;
    }

    public Class<? extends Annotation> getScope() {
        return this.scope;
    }

    public Set<InjectionPoint> getInjectionPoints() {
        return Collections.emptySet();
    }

    public boolean isAlternative() {
        return false;
    }

    public boolean isNullable() {
        return true;
    }

    protected void setScope(Class<? extends Annotation> aScope) {
        this.scope = aScope;
    }
}

