/*
 * Decompiled with CFR 0.152.
 */
package de.openknowledge.cdi.job;

import de.openknowledge.cdi.common.qualifier.Current;
import de.openknowledge.cdi.job.Job;
import de.openknowledge.cdi.job.JobScoped;
import de.openknowledge.cdi.scope.End;
import de.openknowledge.cdi.scope.ThreadScoped;
import java.lang.annotation.Annotation;
import javax.enterprise.inject.Default;
import javax.enterprise.inject.Instance;
import javax.enterprise.inject.Produces;
import javax.inject.Inject;
import org.quartz.JobDataMap;
import org.quartz.JobDetail;
import org.quartz.JobExecutionContext;
import org.quartz.JobExecutionException;

@ThreadScoped
public class CdiJob
implements org.quartz.Job {
    public static final String JOB_CLASS_NAME_PROPERTY = Job.class.getName() + ".class.name";
    @Inject
    @Job
    private Instance<Runnable> jobInstance;
    private JobExecutionContext executionContext;

    protected CdiJob() {
    }

    @Produces
    @Current
    @Default
    @JobScoped
    public JobExecutionContext getJobExecutionContext() {
        return this.executionContext;
    }

    @Produces
    @Current
    @Default
    @JobScoped
    public JobDetail getJobDetail() {
        return this.executionContext.getJobDetail();
    }

    @Produces
    @Current
    @Default
    @JobScoped
    public JobDataMap getJobDataMap() {
        return this.executionContext.getJobDetail().getJobDataMap();
    }

    @End(value={JobScoped.class})
    public void execute(JobExecutionContext context) throws JobExecutionException {
        this.executionContext = context;
        String classname = context.getJobDetail().getJobDataMap().getString(JOB_CLASS_NAME_PROPERTY);
        try {
            Object job = this.getJob(Class.forName(classname));
            job.run();
        }
        catch (ClassNotFoundException e) {
            throw new JobExecutionException((Throwable)e);
        }
    }

    private <T extends Runnable> T getJob(Class<T> type) {
        return (T)((Runnable)this.jobInstance.select(type, new Annotation[0]).get());
    }
}

