/*
 * Decompiled with CFR 0.152.
 */
package de.openknowledge.cdi.lifecycle;

import java.util.HashSet;
import java.util.Set;
import javax.ejb.Startup;
import javax.enterprise.context.spi.CreationalContext;
import javax.enterprise.event.Observes;
import javax.enterprise.inject.spi.AfterDeploymentValidation;
import javax.enterprise.inject.spi.Bean;
import javax.enterprise.inject.spi.BeanManager;
import javax.enterprise.inject.spi.Extension;
import javax.enterprise.inject.spi.ProcessBean;

public class LifecycleExtension
implements Extension {
    private Set<Bean<?>> startupBeans = new HashSet();

    public void registerStartupBean(@Observes ProcessBean<?> event) {
        if (event.getAnnotated().isAnnotationPresent(Startup.class)) {
            this.startupBeans.add(event.getBean());
        }
    }

    public void initializeBeans(@Observes AfterDeploymentValidation event, BeanManager beanManager) {
        for (Bean<?> startupBean : this.startupBeans) {
            CreationalContext creationalContext = beanManager.createCreationalContext(startupBean);
            beanManager.getReference(startupBean, Object.class, creationalContext).toString();
        }
    }
}

