/*
 * Decompiled with CFR 0.152.
 */
package de.openknowledge.cdi.scope;

import java.util.Map;
import javax.enterprise.context.spi.Context;
import javax.enterprise.context.spi.Contextual;
import javax.enterprise.context.spi.CreationalContext;

public abstract class AbstractContext
implements Context {
    public <T> T get(Contextual<T> contextual) {
        return this.get(contextual, null);
    }

    public <T> T get(Contextual<T> contextual, CreationalContext<T> creationalContext) {
        Map<Contextual<?>, Instance<?>> instances = this.getContextualMap(creationalContext);
        Instance<T> instance = this.getInstance(contextual, instances);
        if (instance != null) {
            return instance.get();
        }
        if (creationalContext == null) {
            return null;
        }
        instance = new Instance<T>(contextual, creationalContext);
        instances.put(contextual, instance);
        return instance.get();
    }

    protected abstract Map<Contextual<?>, Instance<?>> getContextualMap(CreationalContext<?> var1);

    private <T> Instance<T> getInstance(Contextual<T> requestedContextual, Map<Contextual<?>, Instance<?>> instances) {
        return instances.get(requestedContextual);
    }

    protected static class Instance<T> {
        private Contextual<T> contextual;
        private CreationalContext<T> creationalContext;
        private T instance;

        public Instance(Contextual<T> contextual, CreationalContext<T> creationalContext) {
            this.contextual = contextual;
            this.creationalContext = creationalContext;
            this.instance = contextual.create(creationalContext);
        }

        public T get() {
            return this.instance;
        }

        public void destroy() {
            this.contextual.destroy(this.instance, this.creationalContext);
        }

        protected Contextual<T> getContextual() {
            return this.contextual;
        }

        protected CreationalContext<T> getCreationalContext() {
            return this.creationalContext;
        }
    }
}

