/*
 * Decompiled with CFR 0.152.
 */
package de.openknowledge.cdi.scope;

import de.openknowledge.cdi.common.spi.CorrespondingLiteral;
import de.openknowledge.cdi.common.spi.SingletonBean;
import de.openknowledge.cdi.scope.Begin;
import de.openknowledge.cdi.scope.DefaultDestroyableContext;
import de.openknowledge.cdi.scope.End;
import java.lang.annotation.Annotation;
import java.util.HashMap;
import java.util.Map;
import javax.enterprise.context.spi.Context;
import javax.enterprise.event.Observes;
import javax.enterprise.inject.spi.AfterBeanDiscovery;
import javax.enterprise.inject.spi.Annotated;
import javax.enterprise.inject.spi.AnnotatedField;
import javax.enterprise.inject.spi.AnnotatedMethod;
import javax.enterprise.inject.spi.AnnotatedType;
import javax.enterprise.inject.spi.Bean;
import javax.enterprise.inject.spi.BeanManager;
import javax.enterprise.inject.spi.Extension;
import javax.enterprise.inject.spi.ProcessBean;

public class DestroyableContextExtension
implements Extension {
    private Map<Class<? extends Annotation>, Bean<?>> destroyableBeans = new HashMap();

    public void registerBean(@Observes ProcessBean<?> beanEvent, BeanManager beanManager) {
        Begin begin;
        End end = this.getAnnotation(End.class, beanEvent.getAnnotated(), beanManager);
        if (end != null) {
            for (Class<? extends Annotation> scope : end.value()) {
                this.destroyableBeans.put(scope, beanEvent.getBean());
            }
        }
        if ((begin = this.getAnnotation(Begin.class, beanEvent.getAnnotated(), beanManager)) != null) {
            for (Class<? extends Annotation> scope : begin.value()) {
                this.destroyableBeans.put(scope, beanEvent.getBean());
            }
        }
    }

    public void registerContexts(@Observes AfterBeanDiscovery afterBeanDiscovery, BeanManager beanManager) {
        for (Map.Entry<Class<Annotation>, Bean<?>> entry : this.destroyableBeans.entrySet()) {
            DefaultDestroyableContext context = new DefaultDestroyableContext(entry.getValue(), entry.getKey(), beanManager);
            afterBeanDiscovery.addContext((Context)context);
            CorrespondingLiteral corresponding = new CorrespondingLiteral(entry.getKey());
            SingletonBean contextBean = new SingletonBean(entry.getKey().getName(), (Object)context, beanManager, new Annotation[]{corresponding});
            afterBeanDiscovery.addBean((Bean)contextBean);
        }
    }

    private <A extends Annotation> A getAnnotation(Class<A> annotationType, Annotated annotated, BeanManager beanManager) {
        Annotation annotation = annotated.getAnnotation(annotationType);
        if (annotation != null) {
            return (A)annotation;
        }
        if (annotated instanceof AnnotatedType) {
            AnnotatedType annotatedType = (AnnotatedType)annotated;
            for (AnnotatedMethod method : annotatedType.getMethods()) {
                annotation = method.getAnnotation(annotationType);
                if (annotation == null) continue;
                return (A)annotation;
            }
            return null;
        }
        if (annotated instanceof AnnotatedField) {
            AnnotatedField field = (AnnotatedField)annotated;
            AnnotatedType fieldType = beanManager.createAnnotatedType(field.getJavaMember().getType());
            return this.getAnnotation(annotationType, (Annotated)fieldType, beanManager);
        }
        if (annotated instanceof AnnotatedMethod) {
            AnnotatedMethod method = (AnnotatedMethod)annotated;
            AnnotatedType returnType = beanManager.createAnnotatedType(method.getJavaMember().getReturnType());
            return this.getAnnotation(annotationType, (Annotated)returnType, beanManager);
        }
        return null;
    }
}

