/*
 * Decompiled with CFR 0.152.
 */
package de.openknowledge.cdi.transaction.jta;

import de.openknowledge.cdi.transaction.jta.DefaultUserTransactionHolder;
import de.openknowledge.cdi.transaction.jta.UserTransactionHolder;
import java.io.Serializable;
import javax.ejb.ApplicationException;
import javax.enterprise.inject.Any;
import javax.enterprise.inject.Instance;
import javax.inject.Inject;
import javax.persistence.EntityManager;
import javax.transaction.HeuristicMixedException;
import javax.transaction.HeuristicRollbackException;
import javax.transaction.NotSupportedException;
import javax.transaction.RollbackException;
import javax.transaction.SystemException;
import javax.transaction.TransactionManager;
import javax.transaction.UserTransaction;

public abstract class AbstractTransactionAttributeInterceptor
implements Serializable {
    @Inject
    private UserTransactionHolder utHolder;
    @Inject
    @Any
    private Instance<EntityManager> entityManagers;

    public TransactionManager getTransactionManager() throws NotSupportedException {
        if (!(this.utHolder.getUserTransaction() instanceof TransactionManager)) {
            throw new NotSupportedException("Cannot receive TransactionManager");
        }
        return (TransactionManager)this.utHolder.getUserTransaction();
    }

    public boolean isTransactionActive() throws SystemException {
        return this.utHolder.getUserTransaction().getStatus() == 0;
    }

    public boolean isTransactionMarkedRollback() throws SystemException {
        return this.utHolder.getUserTransaction().getStatus() == 1;
    }

    public void markTransactionRollbackOnly() throws SystemException {
        this.utHolder.getUserTransaction().setRollbackOnly();
    }

    public void beginTransaction() throws NotSupportedException, SystemException {
        this.utHolder.getUserTransaction().begin();
        if (this.entityManagers != null) {
            for (EntityManager manager : this.entityManagers) {
                manager.joinTransaction();
            }
        }
    }

    public void commitTransaction() throws RollbackException, HeuristicMixedException, HeuristicRollbackException, SystemException {
        this.utHolder.getUserTransaction().commit();
    }

    public void rollbackTransaction() throws SystemException {
        this.utHolder.getUserTransaction().rollback();
    }

    protected void rollbackTransactionIfNeeded(boolean responsible, Exception exception) throws SystemException {
        ApplicationException applicationException;
        if (this.isTransactionActive() && ((applicationException = exception.getClass().getAnnotation(ApplicationException.class)) == null || applicationException.rollback())) {
            this.utHolder.getUserTransaction().setRollbackOnly();
        }
    }

    protected void handleTransactionEnd(boolean responsible) throws SystemException, RollbackException, HeuristicMixedException, HeuristicRollbackException {
        if (responsible) {
            if (this.isTransactionMarkedRollback()) {
                this.rollbackTransaction();
            } else {
                this.commitTransaction();
            }
        }
    }

    public void setUserTransaction(UserTransaction userTransaction) {
        this.utHolder = new DefaultUserTransactionHolder(userTransaction);
    }
}

