/*
 * Decompiled with CFR 0.152.
 */
package de.openknowledge.cdi.transaction.jta;

import de.openknowledge.cdi.transaction.jta.ApplicationException;
import de.openknowledge.cdi.transaction.jta.ApplicationRuntimeException;
import de.openknowledge.cdi.transaction.jta.RequiredTransactionInterceptor;
import de.openknowledge.cdi.transaction.jta.StrictMockTransactionFactory;
import java.lang.reflect.InvocationTargetException;
import javax.interceptor.InvocationContext;
import javax.transaction.UserTransaction;
import org.easymock.EasyMock;
import org.junit.Before;
import org.junit.Test;

public class RequiredTransactionInterceptorTest {
    private StrictMockTransactionFactory transactionFactory;
    private RequiredTransactionInterceptor interceptor;

    @Before
    public void setUp() throws Exception {
        this.transactionFactory = new StrictMockTransactionFactory();
        this.interceptor = new RequiredTransactionInterceptor();
        this.interceptor.setUserTransaction((UserTransaction)this.transactionFactory.getMockTransaction());
    }

    @Test(expected=ApplicationException.class)
    public void beginAndCommitTransaction() throws Exception {
        this.transactionFactory.expectNoTransaction();
        this.transactionFactory.expectBeginTransaction();
        this.transactionFactory.expectCommitTransaction();
        this.transactionFactory.replay();
        try {
            InvocationContext ic = (InvocationContext)EasyMock.createNiceMock(InvocationContext.class);
            EasyMock.expect((Object)ic.proceed()).andThrow((Throwable)new ApplicationException());
            EasyMock.replay((Object[])new Object[]{ic});
            this.interceptor.applyTransaction(ic);
        }
        catch (InvocationTargetException e) {
            if (e.getTargetException() instanceof Error) {
                throw (Error)e.getTargetException();
            }
            throw (Exception)e.getTargetException();
        }
        finally {
            this.transactionFactory.verify();
        }
    }

    @Test(expected=ApplicationRuntimeException.class)
    public void beginAndRollbackTransaction() throws Exception {
        this.transactionFactory.expectNoTransaction();
        this.transactionFactory.expectBeginTransaction();
        this.transactionFactory.expectSetRollbackOnly();
        this.transactionFactory.expectRollbackTransaction();
        this.transactionFactory.replay();
        try {
            InvocationContext ic = (InvocationContext)EasyMock.createNiceMock(InvocationContext.class);
            EasyMock.expect((Object)ic.proceed()).andThrow((Throwable)new ApplicationRuntimeException());
            EasyMock.replay((Object[])new Object[]{ic});
            this.interceptor.applyTransaction(ic);
        }
        catch (InvocationTargetException e) {
            if (e.getTargetException() instanceof Error) {
                throw (Error)e.getTargetException();
            }
            throw (Exception)e.getTargetException();
        }
        finally {
            this.transactionFactory.verify();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test(expected=ApplicationException.class)
    public void activeTransaction() throws Exception {
        this.transactionFactory.expectActiveTransaction();
        this.transactionFactory.replay();
        try {
            InvocationContext ic = (InvocationContext)EasyMock.createNiceMock(InvocationContext.class);
            EasyMock.expect((Object)ic.proceed()).andThrow((Throwable)new ApplicationException());
            EasyMock.replay((Object[])new Object[]{ic});
            this.interceptor.applyTransaction(ic);
        }
        finally {
            this.transactionFactory.verify();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test(expected=ApplicationRuntimeException.class)
    public void activeTransactionSetRollbackOnly() throws Exception {
        this.transactionFactory.expectActiveTransaction();
        this.transactionFactory.expectSetRollbackOnly();
        this.transactionFactory.replay();
        try {
            InvocationContext ic = (InvocationContext)EasyMock.createNiceMock(InvocationContext.class);
            EasyMock.expect((Object)ic.proceed()).andThrow((Throwable)new ApplicationRuntimeException());
            EasyMock.replay((Object[])new Object[]{ic});
            this.interceptor.applyTransaction(ic);
        }
        finally {
            this.transactionFactory.verify();
        }
    }
}

