/*
 * Decompiled with CFR 0.152.
 */
package de.openknowledge.cdi.transaction.jta;

import de.openknowledge.cdi.transaction.jta.ApplicationRuntimeException;
import de.openknowledge.cdi.transaction.jta.StrictMockTransactionFactory;
import de.openknowledge.cdi.transaction.jta.TransactionNotSupportedInterceptor;
import java.lang.reflect.InvocationTargetException;
import javax.interceptor.InvocationContext;
import javax.transaction.UserTransaction;
import org.easymock.EasyMock;
import org.junit.Before;
import org.junit.Test;

public class TransactionNotSupportedInterceptorTest {
    private StrictMockTransactionFactory transactionFactory;
    private TransactionNotSupportedInterceptor interceptor;

    @Before
    public void setUp() throws Exception {
        this.transactionFactory = new StrictMockTransactionFactory();
        this.interceptor = new TransactionNotSupportedInterceptor();
        this.interceptor.setUserTransaction((UserTransaction)this.transactionFactory.getMockTransaction());
    }

    @Test(expected=ApplicationRuntimeException.class)
    public void noTransaction() throws Exception {
        this.transactionFactory.expectNoTransaction();
        this.transactionFactory.replay();
        try {
            InvocationContext ic = (InvocationContext)EasyMock.createNiceMock(InvocationContext.class);
            EasyMock.expect((Object)ic.proceed()).andThrow((Throwable)new ApplicationRuntimeException());
            EasyMock.replay((Object[])new Object[]{ic});
            this.interceptor.applyTransaction(ic);
        }
        catch (InvocationTargetException e) {
            if (e.getTargetException() instanceof Error) {
                throw (Error)e.getTargetException();
            }
            throw (Exception)e.getTargetException();
        }
        finally {
            this.transactionFactory.verify();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test(expected=ApplicationRuntimeException.class)
    public void suspendTransaction() throws Exception {
        this.transactionFactory.expectActiveTransaction();
        this.transactionFactory.expectSuspendTransaction();
        this.transactionFactory.expectResumeTransaction();
        this.transactionFactory.replay();
        try {
            InvocationContext ic = (InvocationContext)EasyMock.createNiceMock(InvocationContext.class);
            EasyMock.expect((Object)ic.proceed()).andThrow((Throwable)new ApplicationRuntimeException());
            EasyMock.replay((Object[])new Object[]{ic});
            this.interceptor.applyTransaction(ic);
        }
        finally {
            this.transactionFactory.verify();
        }
    }
}

