/*
 * Decompiled with CFR 0.152.
 */
package de.openknowledge.cdi.transaction.jta;

import de.openknowledge.cdi.common.spi.DelegatingAnnotatedMethod;
import de.openknowledge.cdi.common.spi.DelegatingAnnotatedType;
import de.openknowledge.cdi.transaction.jta.DelegatingTransactionAttribute;
import de.openknowledge.cdi.transaction.jta.TransactionAttribute;
import java.lang.annotation.Annotation;
import javax.enterprise.event.Observes;
import javax.enterprise.inject.spi.AnnotatedMethod;
import javax.enterprise.inject.spi.AnnotatedType;
import javax.enterprise.inject.spi.Extension;
import javax.enterprise.inject.spi.ProcessAnnotatedType;

public class TransactionAttributeExtension
implements Extension {
    public <T> void replaceTransactionAttribute(@Observes ProcessAnnotatedType<T> event) {
        if (this.isTransactionAttributeAnnotationPresent(event.getAnnotatedType())) {
            event.setAnnotatedType(new TransactionAttributeAnnotatedType(event.getAnnotatedType()));
        }
    }

    private boolean isTransactionAttributeAnnotationPresent(AnnotatedType<?> annotatedType) {
        if (annotatedType.isAnnotationPresent(javax.ejb.TransactionAttribute.class)) {
            return true;
        }
        for (AnnotatedMethod method : annotatedType.getMethods()) {
            if (!method.isAnnotationPresent(javax.ejb.TransactionAttribute.class)) continue;
            return true;
        }
        return false;
    }

    private static class TransactionAttributeAnnotatedType<T>
    extends DelegatingAnnotatedType<T> {
        private TransactionAttribute defaultTransactionAttribute;

        public TransactionAttributeAnnotatedType(AnnotatedType<T> delegateType) {
            super(delegateType, new Annotation[0]);
            javax.ejb.TransactionAttribute transactionAttribute = (javax.ejb.TransactionAttribute)delegateType.getAnnotation(javax.ejb.TransactionAttribute.class);
            if (transactionAttribute != null) {
                this.defaultTransactionAttribute = new DelegatingTransactionAttribute(transactionAttribute);
                this.removeAnnotation(javax.ejb.TransactionAttribute.class);
            }
        }

        protected AnnotatedMethod<? super T> processAnnotatedMethod(AnnotatedMethod<? super T> method) {
            javax.ejb.TransactionAttribute transactionAttribute = (javax.ejb.TransactionAttribute)method.getAnnotation(javax.ejb.TransactionAttribute.class);
            if (transactionAttribute == null && this.defaultTransactionAttribute == null) {
                return method;
            }
            if (transactionAttribute != null) {
                return this.createDelegatingMethod(method, transactionAttribute);
            }
            return this.createDelegatingMethod(method, this.defaultTransactionAttribute);
        }

        private <M> AnnotatedMethod<M> createDelegatingMethod(AnnotatedMethod<M> method, javax.ejb.TransactionAttribute transactionAttribute) {
            return this.createDelegatingMethod(method, new DelegatingTransactionAttribute(transactionAttribute));
        }

        private <M> AnnotatedMethod<M> createDelegatingMethod(AnnotatedMethod<M> method, TransactionAttribute transactionAttribute) {
            DelegatingAnnotatedMethod delegatingMethod = new DelegatingAnnotatedMethod((AnnotatedType)this, method, new Annotation[0]);
            delegatingMethod.addAnnotation((Annotation)transactionAttribute);
            delegatingMethod.removeAnnotation(javax.ejb.TransactionAttribute.class);
            return delegatingMethod;
        }
    }
}

