/*
 * Decompiled with CFR 0.152.
 */
package de.openknowledge.cdi.transaction.jta;

import de.openknowledge.cdi.transaction.jta.ApplicationException;
import de.openknowledge.cdi.transaction.jta.NeverTransactionInterceptor;
import de.openknowledge.cdi.transaction.jta.StrictMockTransactionFactory;
import java.lang.reflect.InvocationTargetException;
import javax.ejb.EJBException;
import javax.interceptor.InvocationContext;
import javax.transaction.UserTransaction;
import org.easymock.EasyMock;
import org.junit.Before;
import org.junit.Test;

public class NeverTransactionInterceptorTest {
    private StrictMockTransactionFactory transactionFactory;
    private NeverTransactionInterceptor interceptor;

    @Before
    public void setUp() throws Exception {
        this.transactionFactory = new StrictMockTransactionFactory();
        this.interceptor = new NeverTransactionInterceptor();
        this.interceptor.setUserTransaction((UserTransaction)this.transactionFactory.getMockTransaction());
    }

    @Test(expected=EJBException.class)
    public void activeTransaction() throws Exception {
        this.transactionFactory.expectActiveTransaction();
        this.transactionFactory.replay();
        try {
            InvocationContext ic = (InvocationContext)EasyMock.createNiceMock(InvocationContext.class);
            EasyMock.expect((Object)ic.proceed()).andThrow((Throwable)new ApplicationException());
            EasyMock.replay((Object[])new Object[]{ic});
            this.interceptor.checkTransaction(ic);
        }
        catch (InvocationTargetException e) {
            if (e.getTargetException() instanceof Error) {
                throw (Error)e.getTargetException();
            }
            throw (Exception)e.getTargetException();
        }
        finally {
            this.transactionFactory.verify();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test(expected=ApplicationException.class)
    public void noTransaction() throws Exception {
        this.transactionFactory.expectNoTransaction();
        this.transactionFactory.replay();
        try {
            InvocationContext ic = (InvocationContext)EasyMock.createNiceMock(InvocationContext.class);
            EasyMock.expect((Object)ic.proceed()).andThrow((Throwable)new ApplicationException());
            EasyMock.replay((Object[])new Object[]{ic});
            this.interceptor.checkTransaction(ic);
        }
        finally {
            this.transactionFactory.verify();
        }
    }
}

