/*
 * Decompiled with CFR 0.152.
 */
package de.openknowledge.cdi.transaction.jta;

import de.openknowledge.cdi.transaction.jta.ReadOnlyInterceptor;
import de.openknowledge.cdi.transaction.jta.RequiredTransactionInterceptor;
import de.openknowledge.cdi.transaction.jta.StrictMockTransactionFactory;
import javax.interceptor.InvocationContext;
import javax.transaction.UserTransaction;
import org.easymock.EasyMock;
import org.easymock.IAnswer;
import org.junit.Before;
import org.junit.Test;

public class ReadOnlyInterceptorTest {
    private StrictMockTransactionFactory transactionFactory;
    private RequiredTransactionInterceptor txInterceptor;
    private ReadOnlyInterceptor readOnlyInterceptor;

    @Before
    public void setUp() throws Exception {
        this.transactionFactory = new StrictMockTransactionFactory();
        this.txInterceptor = new RequiredTransactionInterceptor();
        this.txInterceptor.setUserTransaction((UserTransaction)this.transactionFactory.getMockTransaction());
        this.readOnlyInterceptor = new ReadOnlyInterceptor((UserTransaction)this.transactionFactory.getMockTransaction());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void beginAndRollbackTransaction() throws Exception {
        this.transactionFactory.expectNoTransaction();
        this.transactionFactory.expectBeginTransaction();
        this.transactionFactory.expectSetRollbackOnly();
        this.transactionFactory.expectRollbackTransaction();
        this.transactionFactory.replay();
        try {
            final InvocationContext mock = (InvocationContext)EasyMock.createMock(InvocationContext.class);
            EasyMock.expect((Object)mock.proceed()).andAnswer((IAnswer)new IAnswer<Object>(){

                public Object answer() throws Throwable {
                    return ReadOnlyInterceptorTest.this.readOnlyInterceptor.markReadOnly(mock);
                }
            });
            EasyMock.expect((Object)mock.proceed()).andReturn(null);
            EasyMock.replay((Object[])new Object[]{mock});
            this.txInterceptor.applyTransaction(mock);
            EasyMock.verify((Object[])new Object[]{mock});
        }
        finally {
            this.transactionFactory.verify();
        }
    }
}

