/*
 * Decompiled with CFR 0.152.
 */
package de.openknowledge.cdi.transaction;

import java.util.HashSet;
import java.util.Set;
import javax.transaction.HeuristicMixedException;
import javax.transaction.HeuristicRollbackException;
import javax.transaction.RollbackException;
import javax.transaction.Synchronization;
import javax.transaction.SystemException;
import javax.transaction.Transaction;
import javax.transaction.xa.XAException;
import javax.transaction.xa.XAResource;
import javax.transaction.xa.Xid;

class TransactionImpl
implements Transaction {
    private int status = 6;
    private Set<XAResource> resources = new HashSet<XAResource>();
    private boolean rollbackOnly;
    private Xid xid;

    TransactionImpl() {
    }

    public void commit() throws RollbackException, HeuristicMixedException, HeuristicRollbackException, SecurityException, IllegalStateException, SystemException {
        this.status = 8;
        try {
            for (XAResource res : this.resources) {
                res.prepare(this.xid);
            }
            for (XAResource res : this.resources) {
                res.commit(this.xid, false);
            }
        }
        catch (XAException e) {
            throw new SystemException(e.toString());
        }
        this.status = 3;
    }

    public boolean delistResource(XAResource xaRes, int flag) throws IllegalStateException, SystemException {
        this.resources.remove(xaRes);
        return true;
    }

    public boolean enlistResource(XAResource xaRes) throws RollbackException, IllegalStateException, SystemException {
        this.resources.add(xaRes);
        return true;
    }

    public int getStatus() throws SystemException {
        return this.status;
    }

    public void registerSynchronization(Synchronization sync) throws RollbackException, IllegalStateException, SystemException {
    }

    public void rollback() throws IllegalStateException, SystemException {
        this.status = 9;
        try {
            for (XAResource res : this.resources) {
                res.rollback(this.xid);
            }
        }
        catch (XAException e) {
            throw new SystemException(e.toString());
        }
        this.status = 4;
    }

    public void setRollbackOnly() throws IllegalStateException, SystemException {
        this.status = 1;
        this.rollbackOnly = true;
    }

    public void begin() {
        this.status = 0;
        this.xid = new Xid(){

            @Override
            public int getFormatId() {
                return (int)System.currentTimeMillis();
            }

            @Override
            public byte[] getGlobalTransactionId() {
                return ("mock-id" + this.getFormatId()).getBytes();
            }

            @Override
            public byte[] getBranchQualifier() {
                return ("mock-branch" + this.getFormatId()).getBytes();
            }
        };
    }
}

