/*
 * Decompiled with CFR 0.152.
 */
package de.openknowledge.cdi.transaction.jta;

import de.openknowledge.cdi.common.spi.AbstractCdiBean;
import java.lang.annotation.Annotation;
import javax.enterprise.context.spi.CreationalContext;
import javax.enterprise.event.Observes;
import javax.enterprise.inject.spi.AfterBeanDiscovery;
import javax.enterprise.inject.spi.Bean;
import javax.enterprise.inject.spi.BeanManager;
import javax.enterprise.inject.spi.Extension;
import javax.enterprise.inject.spi.ProcessBean;
import javax.enterprise.inject.spi.ProcessProducerField;
import javax.enterprise.inject.spi.ProcessProducerMethod;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import javax.transaction.UserTransaction;

public class JndiNameUserTransactionExtension
implements Extension {
    public static final String USER_TRANSACTION_JNDI_NAME = "java:comp/env/UserTransaction";
    private String userTransactionName = "java:comp/env/UserTransaction";
    private boolean utxMissing = true;

    protected String getUserTransactionName() {
        return this.userTransactionName;
    }

    public <T> void isUserTransaction(@Observes ProcessBean<T> bean) {
        this.checkUtxAvailability(bean.getBean().getBeanClass());
    }

    public <T, X> void isUserTransaction(@Observes ProcessProducerMethod<T, X> bean) {
        this.checkUtxAvailability(bean.getBean().getBeanClass());
    }

    public <T, X> void isUserTransaction(@Observes ProcessProducerField<T, X> bean) {
        this.checkUtxAvailability(bean.getBean().getBeanClass());
    }

    public void addLinkToResource(@Observes AfterBeanDiscovery event, BeanManager bm) {
        if (this.utxMissing) {
            event.addBean((Bean)new AbstractCdiBean<UserTransaction>("userTransaction", UserTransaction.class, bm, new Annotation[0]){

                public UserTransaction create(CreationalContext<UserTransaction> userTransactionCreationalContext) {
                    InitialContext ctx = null;
                    try {
                        ctx = new InitialContext();
                        UserTransaction userTransaction = (UserTransaction)ctx.lookup(JndiNameUserTransactionExtension.this.getUserTransactionName());
                        return userTransaction;
                    }
                    catch (NamingException e) {
                        throw new RuntimeException(e);
                    }
                    finally {
                        try {
                            if (ctx != null) {
                                ctx.close();
                            }
                        }
                        catch (NamingException e) {}
                    }
                }

                public void destroy(UserTransaction instance, CreationalContext<UserTransaction> userTransactionCreationalContext) {
                }
            });
        }
    }

    protected void checkUtxAvailability(Class<?> aBeanClass) {
        if (UserTransaction.class.isAssignableFrom(aBeanClass)) {
            this.utxMissing = false;
        }
    }
}

