/*
 * Decompiled with CFR 0.152.
 */
package de.openknowledge.cdi.transaction;

import de.openknowledge.cdi.transaction.TransactionImpl;
import javax.transaction.HeuristicMixedException;
import javax.transaction.HeuristicRollbackException;
import javax.transaction.InvalidTransactionException;
import javax.transaction.NotSupportedException;
import javax.transaction.RollbackException;
import javax.transaction.SystemException;
import javax.transaction.Transaction;
import javax.transaction.TransactionManager;
import javax.transaction.UserTransaction;

public class MockTransaction
implements UserTransaction,
TransactionManager {
    private static ThreadLocal<TransactionImpl> transaction = new ThreadLocal();
    private static MockTransaction transactionManager = new MockTransaction();

    public static MockTransaction getTransactionManager() {
        return transactionManager;
    }

    public Transaction getTransaction() throws SystemException {
        return this.getInternalTx();
    }

    public void resume(Transaction tobj) throws InvalidTransactionException, IllegalStateException, SystemException {
        transaction.set((TransactionImpl)tobj);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Transaction suspend() throws SystemException {
        try {
            TransactionImpl transactionImpl = this.getInternalTx();
            return transactionImpl;
        }
        finally {
            transaction.set(new TransactionImpl());
        }
    }

    public void begin() throws NotSupportedException, SystemException {
        this.getInternalTx().begin();
    }

    public void commit() throws RollbackException, HeuristicMixedException, HeuristicRollbackException, SecurityException, IllegalStateException, SystemException {
        this.getInternalTx().commit();
    }

    public void rollback() throws IllegalStateException, SecurityException, SystemException {
        this.getInternalTx().rollback();
    }

    public void setRollbackOnly() throws IllegalStateException, SystemException {
        this.getInternalTx().setRollbackOnly();
    }

    public int getStatus() throws SystemException {
        return this.getInternalTx().getStatus();
    }

    public void setTransactionTimeout(int seconds) throws SystemException {
    }

    public TransactionImpl getInternalTx() {
        if (transaction.get() == null) {
            transaction.set(new TransactionImpl());
        }
        return transaction.get();
    }
}

