/*
 * Decompiled with CFR 0.152.
 */
package de.openknowledge.util.dge.sample.pet01.bean;

import de.openknowledge.util.dge.filter.web.FilterAssembler;
import de.openknowledge.util.dge.sample.pet01.domain.Pet;
import de.openknowledge.util.dge.sample.pet01.domain.PetLineChoices;
import de.openknowledge.util.dge.sample.pet01.domain.Species;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.PostConstruct;
import javax.enterprise.context.SessionScoped;
import javax.inject.Named;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.joda.time.DateMidnight;

@Named
@SessionScoped
public class PetBean
implements Serializable {
    private static final Log LOG = LogFactory.getLog(PetBean.class);
    private List<Pet> pets;
    private FilterAssembler filterAssembler;

    protected PetBean() {
    }

    public List<Pet> getFilteredPets() {
        if (this.pets == null) {
            this.init();
        }
        return (List)this.getFilterAssembler().filter(new ArrayList(this.pets));
    }

    public FilterAssembler<List<Pet>> getFilterAssembler() {
        if (this.filterAssembler == null) {
            this.filterAssembler = new FilterAssembler(Pet.class, new Object[]{PetLineChoices.class, new PetLineChoices()});
            this.filterAssembler.setFilterActive(true);
        }
        return this.filterAssembler;
    }

    public void applyFilter() {
        LOG.info((Object)"applying filter");
    }

    @PostConstruct
    public void init() {
        LOG.info((Object)"Creating pets...");
        this.pets = new ArrayList();
        Pet p1 = new Pet();
        p1.setName("Funny");
        p1.setSpecies(Species.DOG);
        p1.setDateOfBirth(new DateMidnight(1990, 2, 3).toDate());
        this.pets.add(p1);
        Pet p2 = new Pet();
        p2.setName("Evi");
        p2.setSpecies(Species.CAT);
        p2.setDateOfBirth(new DateMidnight(1996, 7, 14).toDate());
        this.pets.add(p2);
        Pet p3 = new Pet();
        p3.setName("Bandit");
        p3.setSpecies(Species.DOG);
        p3.setDateOfBirth(new DateMidnight(2011, 5, 5).toDate());
        this.pets.add(p3);
        Pet p4 = new Pet();
        p4.setName("Whisky");
        p4.setSpecies(Species.CAT);
        p4.setDateOfBirth(new DateMidnight(2011, 4, 20).toDate());
        this.pets.add(p4);
        Pet p5 = new Pet();
        p5.setName("Tweety");
        p5.setSpecies(Species.BIRD);
        p5.setDateOfBirth(new DateMidnight(2007, 7, 31).toDate());
        this.pets.add(p5);
        LOG.info((Object)(this.pets.size() + " pets have been created."));
    }
}

