#set( $symbol_pound = '#' )
#set( $symbol_dollar = '$' )
#set( $symbol_escape = '\' )
/*
 * ${package}.web.filter.RequestLogFilterMockTest.java
 *
 *
 * This document contains trade secret data which is the property of OpenKnowledge GmbH. Information contained herein
 * may not be used, copied or disclosed in whole or part except as permitted by written agreement from OpenKnowledge
 * GmbH.
 *
 * Copyright(C)2013 open knowledge GmbH / Oldenburg / Germany
 */
package ${package}.web.filter;

import static org.junit.Assert.assertNotNull;
import static org.junit.Assert.assertTrue;
import static org.mockito.Matchers.any;
import static org.mockito.Mockito.doAnswer;

import javax.servlet.FilterChain;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;

import org.apache.commons.lang3.ObjectUtils;
import org.apache.log4j.MDC;
import org.junit.Before;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.junit.runner.RunWith;
import org.mockito.Mock;
import org.mockito.invocation.InvocationOnMock;
import org.mockito.runners.MockitoJUnitRunner;
import org.mockito.stubbing.Answer;

import ${package}.core.test.DevelopmentTests;

/**
 * Mock TEST_DATA class for the filter {@link RequestLogFilter}.
 */
@RunWith(MockitoJUnitRunner.class)
@Category(DevelopmentTests.class)
public class RequestLogFilterMockTest {

  private RequestLogFilter filter;

  @Mock
  private ServletRequest request;

  @Mock
  private ServletResponse response;

  @Mock
  private FilterChain chain;

  @Before
  public void setUp()
      throws Exception {

    filter = new RequestLogFilter();
  }

  @Test
  public void doFilter()
      throws Exception {
    UniqueIdAnswer answerOne = new UniqueIdAnswer();
    UniqueIdAnswer answerTwo = new UniqueIdAnswer();

    doAnswer(answerOne).when(chain).doFilter(any(ServletRequest.class), any(ServletResponse.class));

    filter.doFilter(request, response, chain);
    String requestIdOne = answerOne.getUniqueId();
    assertNotNull(requestIdOne);

    doAnswer(answerTwo).when(chain).doFilter(any(ServletRequest.class), any(ServletResponse.class));

    filter.doFilter(request, response, chain);
    String requestIdTwo = answerTwo.getUniqueId();
    assertNotNull(requestIdTwo);

    assertTrue(ObjectUtils.notEqual(requestIdOne, requestIdTwo));
  }

  public class UniqueIdAnswer implements Answer<Void> {

    private String uniqueId;

    public String getUniqueId() {
      return uniqueId;
    }

    @Override
    public Void answer(InvocationOnMock invocation) {
      uniqueId = (String)MDC.get(RequestLogFilter.UNIQUE_ID);
      return null;
    }
  }
}
