#set( $symbol_pound = '#' )
#set( $symbol_dollar = '$' )
#set( $symbol_escape = '\' )
/*
 *
 * ${package}.domain.AbstractValueObject.java
 *
 *
 * This document contains trade secret data which is the property of OpenKnowledge GmbH. Information contained herein
 * may not be used, copied or disclosed in whole or part except as permitted by written agreement from OpenKnowledge
 * GmbH.
 *
 * Copyright (C) 2013 open knowledge GmbH / Oldenburg / Germany
 */
package ${package}.domain;

import static org.apache.commons.lang3.Validate.notNull;

import java.io.Serializable;
import javax.persistence.Access;
import javax.persistence.AccessType;
import javax.persistence.Column;
import javax.persistence.MappedSuperclass;

/**
 * Abstract value object. Provides means for value object classes.
 */
@MappedSuperclass
@Access(AccessType.FIELD)
public abstract class AbstractValueObject<V extends Comparable<V>> implements Serializable, Comparable<AbstractValueObject<V>> {

  @Column(name = "value")
  private V value;

  protected AbstractValueObject() {
    super();
  }

  public AbstractValueObject(V value) {
    this.value = validate(value);
  }

  public V getValue() {
    return value;
  }

  /**
   * Validation and normalization callback used during construction of the value object. Subclasses may override this
   * method to alter validation and normalization.
   *
   * @param parameterValue The constructor value.
   * @return The validated and normalized value.
   */
  protected V validate(V parameterValue) {
    notNull(parameterValue, "Paramter 'value' must not be 'NULL'");
    return parameterValue;
  }

  @Override
  public int hashCode() {
    return getValue().hashCode();
  }

  @Override
  public boolean equals(Object object) {
    if (this == object) {
      return true;
    }
    if (object == null
        || !(object.getClass().isAssignableFrom(getClass()) || getClass().isAssignableFrom(object.getClass()))) {
      return false;
    }
    @SuppressWarnings("unchecked")
    AbstractValueObject<V> valueObject = (AbstractValueObject<V>)object;
    return valueObject.getValue().equals(getValue());
  }

  @Override
  public String toString() {
    return getValue().toString();
  }

  @Override
  public int compareTo(AbstractValueObject<V> object) {
    return getValue().compareTo(object.getValue());
  }
}
