#set( $symbol_pound = '#' )
#set( $symbol_dollar = '$' )
#set( $symbol_escape = '\' )
package ${package}.domain.user;

import static org.apache.commons.lang3.Validate.notNull;

import javax.persistence.AttributeOverride;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.NamedQuery;
import javax.persistence.Table;

import ${package}.domain.AbstractEntity;


/**
 * Created by pierre.liebsch on 30.09.13.
 */
@Entity
@Table(name = "TAB_USER")
@NamedQuery(name = "User.findByUsername", query = "select u from User u where u.name = :username")
public class User extends AbstractEntity {

  @AttributeOverride(name = "value", column = @Column(name = "USER_USERNAME"))
  private Username name;
  @AttributeOverride(name = "value", column = @Column(name = "USER_PASSWORD"))
  private EncryptedPassword password;


  protected User() {
    //for JPA
  }

  public User(Username name, EncryptedPassword password) {
    setName(notNull(name));
    setPassword(notNull(password));
  }

  public Username getName() {
    return name;
  }

  private void setName(Username name) {
    if (name == null) {
      throw new NullPointerException("Username can not be null");
    }
    this.name = name;
  }

  public EncryptedPassword getPassword() {
    return password;
  }

  public void setPassword(EncryptedPassword password) {
    if (password == null) {
      throw new NullPointerException("Password can not be null");
    }
    this.password = password;
  }
}
