#set( $symbol_pound = '#' )
#set( $symbol_dollar = '$' )
#set( $symbol_escape = '\' )
/*
 *
 * ${package}.domain.AbstractJpaTest.java
 *
 *
 * This document contains trade secret data which is the property of OpenKnowledge GmbH. Information contained herein
 * may not be used, copied or disclosed in whole or part except as permitted by written agreement from OpenKnowledge
 * GmbH.
 *
 * Copyright (C) 2013 open knowledge GmbH / Oldenburg / Germany
 */
package ${package}.domain;

import javax.persistence.EntityManager;
import javax.persistence.EntityManagerFactory;
import javax.persistence.Persistence;

import org.junit.After;
import org.junit.AfterClass;
import org.junit.Before;
import org.junit.BeforeClass;

public class AbstractJpaTest {

  private static final String PERSISTENCE_UNIT = "test";
  private static EntityManagerFactory entityManagerFactory;
  private EntityManager entityManager;

  @BeforeClass
  public static void createEntityManagerFactory() {
    entityManagerFactory = Persistence.createEntityManagerFactory(PERSISTENCE_UNIT);
  }

  @AfterClass
  public static void closeEntityManagerFactory() {
    entityManagerFactory.close();
  }

  @Before
  public void createEntityManager() {
    entityManager = entityManagerFactory.createEntityManager();
  }

  @After
  public void closeEntityManager() {
    if (!entityManager.isOpen()) {
      return;
    }
    if (entityManager.getTransaction().isActive()) {
      entityManager.getTransaction().rollback();
    }
    entityManager.close();
  }

  public EntityManager getEntityManager() {
    return entityManager;
  }
}
