#set( $symbol_pound = '#' )
#set( $symbol_dollar = '$' )
#set( $symbol_escape = '\' )
/*
 *
 * ${package}.core.trace.TraceInterceptor.java
 *
 *
 * This document contains trade secret data which is the property of OpenKnowledge GmbH. Information contained herein
 * may not be used, copied or disclosed in whole or part except as permitted by written agreement from OpenKnowledge
 * GmbH.
 *
 * Copyright (C) 2013 open knowledge GmbH / Oldenburg / Germany
 */
package ${package}.core.trace;

import java.util.Arrays;
import javax.interceptor.AroundInvoke;
import javax.interceptor.Interceptor;
import javax.interceptor.InvocationContext;

import org.apache.log4j.Logger;

/**
 * An interceptor that enables tracing of method calls.
 */
@Trace
@Interceptor
public class TraceInterceptor {

  private static final Logger LOGGER = Logger.getLogger(TraceInterceptor.class);

  @AroundInvoke
  public Object traceCall(InvocationContext ctx) throws Exception {
    LOGGER.debug("Calling " + ctx.getMethod() + " of " + ctx.getTarget() + " with arguments " + Arrays.toString(ctx.getParameters()));
    try {
      Object result = ctx.proceed();
      LOGGER.debug("Returning " + result + " for " + ctx.getMethod() + " in " + ctx.getTarget());
      return result;
    } catch (Exception e) {
      LOGGER.debug("Caught exception while processing " + ctx.getTarget() + " at " + ctx.getMethod(), e);
      throw e;
    }
  }
}
