#set( $symbol_pound = '#' )
#set( $symbol_dollar = '$' )
#set( $symbol_escape = '\' )
/*
 *
 * ${package}.core.trace.TraceInterceptorTest.java
 *
 *
 * This document contains trade secret data which is the property of OpenKnowledge GmbH. Information contained herein
 * may not be used, copied or disclosed in whole or part except as permitted by written agreement from OpenKnowledge
 * GmbH.
 *
 * Copyright (C) 2013 open knowledge GmbH / Oldenburg / Germany
 */
package ${package}.core.trace;

import static org.hamcrest.CoreMatchers.is;
import static org.hamcrest.CoreMatchers.nullValue;
import static org.junit.Assert.assertThat;
import static org.mockito.Mockito.mock;
import static org.mockito.Mockito.times;
import static org.mockito.Mockito.verify;
import static org.mockito.Mockito.when;

import javax.interceptor.InvocationContext;

import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.junit.runner.RunWith;
import org.mockito.runners.MockitoJUnitRunner;

import ${package}.core.test.DevelopmentTests;

/**
 * Test class for the interceptor {@link TraceInterceptor}.
 */
@RunWith(MockitoJUnitRunner.class)
@Category(DevelopmentTests.class)
public class TraceInterceptorTest {

  private static final String TEST_STRING = "test";

  @Test
  public void noParameterInterception() throws Exception {

    InvocationContext ctx = mock(InvocationContext.class);
    when(ctx.getMethod()).thenReturn(TestBean.class.getMethod("noParameterMethod"));
    when(ctx.getParameters()).thenReturn(null);
    when(ctx.getTarget()).thenReturn(new TestBean());

    TraceInterceptor interceptor = new TraceInterceptor();
    Object object = interceptor.traceCall(ctx);

    assertThat(object, nullValue());
    verify(ctx, times(2)).getMethod();
    verify(ctx, times(1)).getParameters();
    verify(ctx, times(2)).getTarget();
  }

  @Test
  public void parameterInterception() throws Exception {

    InvocationContext ctx = mock(InvocationContext.class);
    when(ctx.getMethod()).thenReturn(TestBean.class.getMethod("parameterMethod", String.class));
    when(ctx.getParameters()).thenReturn(new Object[]{TEST_STRING});
    when(ctx.getTarget()).thenReturn(new TestBean());

    TraceInterceptor interceptor = new TraceInterceptor();
    Object object = interceptor.traceCall(ctx);

    assertThat(object, nullValue());
    verify(ctx, times(2)).getMethod();
    verify(ctx, times(1)).getParameters();
    verify(ctx, times(2)).getTarget();
  }

  @Test
  public void returnValueInterception() throws Exception {

    InvocationContext ctx = mock(InvocationContext.class);
    when(ctx.getMethod()).thenReturn(TestBean.class.getMethod("returnMethod", String.class));
    when(ctx.getParameters()).thenReturn(new Object[]{TEST_STRING});
    when(ctx.getTarget()).thenReturn(new TestBean());
    when(ctx.proceed()).thenReturn(new TestBean().returnMethod(TEST_STRING));

    TraceInterceptor interceptor = new TraceInterceptor();
    Object object = interceptor.traceCall(ctx);

    assertThat((String)object, is(TEST_STRING));
    verify(ctx, times(2)).getMethod();
    verify(ctx, times(1)).getParameters();
    verify(ctx, times(2)).getTarget();
    verify(ctx, times(1)).proceed();
  }

  @Test(expected = NullPointerException.class)
  public void notNull() throws Exception {
    TraceInterceptor interceptor = new TraceInterceptor();
    interceptor.traceCall(null);
  }

  class TestBean {

    public void noParameterMethod() {

    }

    public void parameterMethod(String param) {

    }

    public Object returnMethod(String param) {
      return param;
    }
  }
}
