/*
 * Decompiled with CFR 0.152.
 */
package de.openknowledge.util.dge.filter;

import de.openknowledge.util.dge.filter.FilterExpression;
import de.openknowledge.util.dge.filter.FilterFieldType;
import de.openknowledge.util.dge.filter.FilterOperand;
import java.lang.reflect.Method;
import java.math.BigDecimal;
import java.util.Date;

public class FilterFieldMetaData {
    private int order;
    private Method targetMethod;
    private FilterFieldType type;
    private String displayName;

    public FilterFieldMetaData(FilterFieldType aType, Method aTargetMethod, int aOrder, String aDisplayName) {
        this.targetMethod = aTargetMethod;
        this.type = aType;
        this.order = aOrder;
        this.displayName = aDisplayName;
    }

    public FilterExpression createFilterExpression(FilterOperand aFilterOperand, Object o) {
        switch (this.type) {
            case BIGDECIMAL: {
                return new FilterExpression<BigDecimal>(this, aFilterOperand, (BigDecimal)o);
            }
            case DATE: {
                return new FilterExpression<Date>(this, aFilterOperand, (Date)o);
            }
            case SELECT: {
                return new FilterExpression<Comparable>(this, aFilterOperand, (Comparable)o);
            }
        }
        throw new IllegalArgumentException("FilterFieldType " + (Object)((Object)this.type) + " not supported");
    }

    public Object getValue(Object targetObject) {
        try {
            return this.targetMethod.invoke(targetObject, new Object[0]);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public Method getTargetMethod() {
        return this.targetMethod;
    }

    public FilterFieldType getType() {
        return this.type;
    }

    public int getOrder() {
        return this.order;
    }

    public String getDisplayName() {
        return this.displayName;
    }
}

