/*
 * Decompiled with CFR 0.152.
 */
package de.openknowledge.util.dge.filter;

import de.openknowledge.util.dge.filter.FilterChoiceFieldMetaData;
import de.openknowledge.util.dge.filter.FilterExpression;
import de.openknowledge.util.dge.filter.FilterFieldMetaData;
import de.openknowledge.util.dge.filter.FilterFieldType;
import de.openknowledge.util.dge.filter.annotation.FilterChoice;
import de.openknowledge.util.dge.filter.annotation.FilterChoiceField;
import de.openknowledge.util.dge.filter.annotation.FilterField;
import java.lang.reflect.Method;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang.Validate;

public class FilterManager<T extends Collection> {
    private List<FilterFieldMetaData> filterFieldMetaData;
    private List<Object> choiceHolders = new ArrayList<Object>();
    private Class<?> filterLine;
    private List<FilterExpression> expressions = new ArrayList<FilterExpression>();

    public FilterManager(Class<?> aFilterLine) {
        Validate.notNull(aFilterLine);
        this.filterLine = aFilterLine;
    }

    public FilterManager(Class<?> aFilterLine, List<Object> theChoiceHolders) {
        this(aFilterLine);
        Validate.notNull(this.choiceHolders);
        this.choiceHolders = theChoiceHolders;
    }

    public T filter(T lines) {
        ArrayList removeList = new ArrayList();
        block0: for (Object line : lines) {
            for (FilterExpression expression : this.expressions) {
                if (expression.matches(line)) continue;
                removeList.add(line);
                continue block0;
            }
        }
        lines.removeAll(removeList);
        return lines;
    }

    public Method getFilterFieldMethod(String methodName) {
        Validate.notNull((Object)methodName);
        for (FilterFieldMetaData md : this.getFilterFieldMetaData()) {
            if (!md.getTargetMethod().getName().equals(methodName)) continue;
            return md.getTargetMethod();
        }
        return null;
    }

    protected Map<String, Method> extractChoiceMethods() {
        HashMap<String, Method> choiceMethods = new HashMap<String, Method>();
        ArrayList<Method> methods = new ArrayList<Method>();
        for (Object choiceHolder : this.choiceHolders) {
            methods.addAll(Arrays.asList(choiceHolder.getClass().getMethods()));
        }
        for (Method method : methods) {
            FilterChoice annotation = method.getAnnotation(FilterChoice.class);
            if (annotation == null) continue;
            choiceMethods.put(annotation.value(), method);
        }
        return choiceMethods;
    }

    protected void extractMetaData() {
        Method[] methods = this.filterLine.getMethods();
        this.filterFieldMetaData = new ArrayList<FilterFieldMetaData>();
        Map<String, Method> choiceMethods = this.extractChoiceMethods();
        for (Method method : methods) {
            FilterChoiceField choiceAnnotation;
            FilterField annotation = method.getAnnotation(FilterField.class);
            if (annotation != null) {
                if (BigDecimal.class.equals(method.getReturnType())) {
                    this.filterFieldMetaData.add(new FilterFieldMetaData(FilterFieldType.BIGDECIMAL, method, annotation.order(), annotation.displayName()));
                } else if (Date.class.equals(method.getReturnType())) {
                    this.filterFieldMetaData.add(new FilterFieldMetaData(FilterFieldType.DATE, method, annotation.order(), annotation.displayName()));
                } else {
                    throw new IllegalArgumentException("Unsupported return type " + method.getReturnType());
                }
            }
            if (choiceMethods.isEmpty() || (choiceAnnotation = method.getAnnotation(FilterChoiceField.class)) == null) continue;
            if (choiceMethods.containsKey(choiceAnnotation.sourceName())) {
                this.filterFieldMetaData.add(new FilterChoiceFieldMetaData(method, choiceMethods.get(choiceAnnotation.sourceName()), choiceAnnotation.order(), choiceAnnotation.displayName()));
                continue;
            }
            throw new IllegalArgumentException("FilterChoice method not found for FilterChoiceField " + method.getName());
        }
        Collections.sort(this.filterFieldMetaData, new Comparator<FilterFieldMetaData>(){

            @Override
            public int compare(FilterFieldMetaData o1, FilterFieldMetaData o2) {
                return o1.getOrder() > o2.getOrder() ? 1 : -1;
            }
        });
    }

    public List<FilterFieldMetaData> getFilterFieldMetaData() {
        if (this.filterFieldMetaData == null) {
            this.extractMetaData();
        }
        return this.filterFieldMetaData;
    }

    public void addExpression(FilterExpression expression) {
        this.expressions.add(expression);
    }

    public void removeExpression(FilterExpression expression) {
        this.expressions.remove(expression);
    }

    public void resetExpressions() {
        this.expressions = new ArrayList<FilterExpression>();
    }

    public List<FilterExpression> getExpressions() {
        return this.expressions;
    }
}

