/*
 * Decompiled with CFR 0.152.
 */
package de.openknowledge.util.dge.grouping;

import de.openknowledge.util.dge.grouping.Line;
import de.openknowledge.util.dge.grouping.ValueLine;
import java.io.Serializable;
import java.lang.reflect.Method;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public final class AggregationLine<E extends Serializable>
extends Line {
    private String displayName;
    private List<ValueLine<E>> valueLines;
    private Map<String, BigDecimal> values;

    public AggregationLine(String aDisplayName) {
        this.displayName = aDisplayName;
        this.valueLines = new ArrayList<ValueLine<E>>();
        this.values = new HashMap<String, BigDecimal>();
    }

    public String getDisplayName() {
        return this.displayName;
    }

    public List<ValueLine<E>> getValueLines() {
        return this.valueLines;
    }

    public void addValueLine(ValueLine<E> aValueLine, List<Method> aAggregrationMethods) {
        for (Method m : aAggregrationMethods) {
            try {
                this.values = this.putOrAddValue(this.values, m.getName(), (BigDecimal)m.invoke(aValueLine.getObject(), new Object[0]));
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
        this.valueLines.add(aValueLine);
    }

    protected Map putOrAddValue(Map<String, BigDecimal> map, String key, BigDecimal addValue) {
        BigDecimal value = map.containsKey(key) ? map.get(key) : BigDecimal.ZERO;
        map.put(key, value.add(addValue));
        return map;
    }

    public BigDecimal getValue(String key) {
        return this.values.get(key);
    }

    @Override
    public boolean isExpanded() {
        return this.expanded;
    }

    @Override
    public boolean isAggregated() {
        return true;
    }
}

