/*
 * Decompiled with CFR 0.152.
 */
package de.openknowledge.cdi.common.property.source;

import de.openknowledge.cdi.common.property.source.AbstractPropertySourceLoader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.net.URI;
import java.util.Properties;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class FilePropertySourceLoader
extends AbstractPropertySourceLoader {
    public static final String FILE_SCHEME = "file";
    private static final Log LOG = LogFactory.getLog(FilePropertySourceLoader.class);

    @Override
    public boolean supports(URI source) {
        return FILE_SCHEME.equals(source.getScheme());
    }

    @Override
    public Properties load(URI resource) {
        Properties properties = new Properties();
        try {
            File file = resource.isOpaque() ? new File(resource.getSchemeSpecificPart()) : new File(resource);
            if (file.exists() && file.canRead()) {
                LOG.debug((Object)("Loading properties from file " + file));
                this.loadFromStream(properties, new FileInputStream(file));
            } else {
                LOG.debug((Object)("Unable to load properties from file " + file + ". File does not exist or is not readable."));
            }
        }
        catch (IOException e) {
            LOG.warn((Object)("Error loading properties from file resource " + resource + ": " + e.getMessage()));
        }
        return properties;
    }
}

