/*
 * Decompiled with CFR 0.152.
 */
package de.openknowledge.cdi.test;

import java.lang.annotation.Annotation;
import java.util.HashSet;
import java.util.Iterator;
import javax.enterprise.context.RequestScoped;
import javax.enterprise.context.spi.Contextual;
import javax.enterprise.context.spi.CreationalContext;
import javax.enterprise.inject.spi.Bean;
import javax.enterprise.inject.spi.BeanManager;
import org.apache.webbeans.config.WebBeansContext;
import org.apache.webbeans.inject.OWBInjector;
import org.apache.webbeans.spi.ContainerLifecycle;
import org.apache.webbeans.spi.ContextsService;
import org.junit.runners.BlockJUnit4ClassRunner;
import org.junit.runners.model.FrameworkMethod;
import org.junit.runners.model.InitializationError;
import org.junit.runners.model.Statement;

public class CdiJunit4TestRunner
extends BlockJUnit4ClassRunner {
    public static final String JUNIT_TEST = "junit.test";
    private Class<?> testType;
    private OWBInjector owbInjector;

    public CdiJunit4TestRunner(Class<?> type) throws InitializationError {
        super(type);
        this.testType = type;
    }

    protected Object createTest() throws Exception {
        System.setProperty(JUNIT_TEST, "true");
        ContainerLifecycle lifecycle = (ContainerLifecycle)WebBeansContext.currentInstance().getService(ContainerLifecycle.class);
        lifecycle.startApplication(this.testType);
        BeanManager beanManager = lifecycle.getBeanManager();
        HashSet testBeans = new HashSet(beanManager.getBeans(this.testType, new Annotation[0]));
        Iterator i = testBeans.iterator();
        while (i.hasNext()) {
            if (((Bean)i.next()).getBeanClass().equals(this.testType)) continue;
            i.remove();
        }
        if (testBeans.isEmpty()) {
            Object test = super.createTest();
            this.owbInjector = new OWBInjector();
            this.owbInjector.inject(test);
            return test;
        }
        Bean testBean = beanManager.resolve(testBeans);
        CreationalContext creationalContext = beanManager.createCreationalContext((Contextual)testBean);
        return beanManager.getReference(testBean, this.testType, creationalContext);
    }

    protected Statement methodBlock(FrameworkMethod method) {
        return new OpenWebBeansStopApplicationStatement(super.methodBlock(method));
    }

    protected Statement withPotentialTimeout(FrameworkMethod method, Object test, Statement next) {
        return super.withPotentialTimeout(method, test, (Statement)new RequestScopedStatement(next));
    }

    public class RequestScopedStatement
    extends Statement {
        private Statement next;

        public RequestScopedStatement(Statement next) {
            this.next = next;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void evaluate() throws Throwable {
            ContextsService contextsService = WebBeansContext.currentInstance().getContextsService();
            try {
                contextsService.startContext(RequestScoped.class, null);
                this.next.evaluate();
            }
            finally {
                contextsService.endContext(RequestScoped.class, null);
            }
        }
    }

    public class OpenWebBeansStopApplicationStatement
    extends Statement {
        private Statement delegate;

        public OpenWebBeansStopApplicationStatement(Statement statement) {
            this.delegate = statement;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void evaluate() throws Throwable {
            try {
                this.delegate.evaluate();
            }
            finally {
                System.clearProperty(CdiJunit4TestRunner.JUNIT_TEST);
                if (CdiJunit4TestRunner.this.owbInjector != null) {
                    CdiJunit4TestRunner.this.owbInjector.destroy();
                    CdiJunit4TestRunner.this.owbInjector = null;
                }
                ContainerLifecycle lifecycle = (ContainerLifecycle)WebBeansContext.currentInstance().getService(ContainerLifecycle.class);
                lifecycle.stopApplication((Object)CdiJunit4TestRunner.this.testType);
            }
        }
    }
}

