/*
 * Decompiled with CFR 0.152.
 */
package de.openknowledge.util.dge.filter;

import de.openknowledge.util.dge.filter.FilterFieldMetaData;
import de.openknowledge.util.dge.filter.FilterFieldType;
import java.lang.reflect.Method;
import java.util.Collection;
import org.apache.commons.lang.Validate;

public class FilterChoiceFieldMetaData
extends FilterFieldMetaData {
    private Method choiceMethod;

    public FilterChoiceFieldMetaData(Method aTargetMethod, Method aChoiceMethod, int aOrder, String aDisplayName) {
        super(FilterFieldType.SELECT, aTargetMethod, aOrder, aDisplayName);
        Validate.isTrue((boolean)Collection.class.isAssignableFrom(aChoiceMethod.getReturnType()), (String)("choiceMethod must have a return type which implements Collection. Return type of " + aChoiceMethod.getName() + " is " + aChoiceMethod.getReturnType().toString()));
        this.choiceMethod = aChoiceMethod;
    }

    public Object getChoiceValues(Object targetObject) {
        try {
            return this.choiceMethod.invoke(targetObject, new Object[0]);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public Method getChoiceMethod() {
        return this.choiceMethod;
    }
}

