/*
 * Decompiled with CFR 0.152.
 */
package de.openknowledge.util.dge.filter;

import de.openknowledge.util.dge.filter.FilterFieldMetaData;
import de.openknowledge.util.dge.filter.FilterManager;
import de.openknowledge.util.dge.filter.FilterOperand;
import de.openknowledge.util.dge.filter.annotation.FilterChoice;
import de.openknowledge.util.dge.filter.annotation.FilterChoiceField;
import de.openknowledge.util.dge.filter.annotation.FilterField;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Date;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class FilterManagerTest {
    private static final Log LOG = LogFactory.getLog(FilterManagerTest.class);
    private FilteredChoiceTestLine l1;
    private FilteredChoiceTestLine l2;
    private FilteredChoiceTestLine l3;
    private List<FilteredChoiceTestLine> lines;

    @Before
    public void init() {
        this.lines = new ArrayList<FilteredChoiceTestLine>();
        BigDecimal bd1 = new BigDecimal("1000");
        Calendar c1 = Calendar.getInstance();
        c1.set(2012, 0, 1, 0, 0, 0);
        c1.set(14, 0);
        this.l1 = new FilteredChoiceTestLine(bd1, c1.getTime(), "MPE");
        this.lines.add(this.l1);
        BigDecimal bd2 = new BigDecimal("2000");
        Calendar c2 = Calendar.getInstance();
        c2.set(2012, 0, 1, 0, 0, 0);
        c2.set(14, 0);
        this.l2 = new FilteredChoiceTestLine(bd2, c2.getTime(), "JSC");
        this.lines.add(this.l2);
        BigDecimal bd3 = new BigDecimal("2000");
        Calendar c3 = Calendar.getInstance();
        c3.set(2013, 0, 1, 0, 0, 0);
        c3.set(14, 0);
        this.l3 = new FilteredChoiceTestLine(bd3, c3.getTime(), "MPE");
        this.lines.add(this.l3);
    }

    @Test
    public void createFilterMetaData() throws Exception {
        FilterManager fs = new FilterManager(FilteredTestLine.class);
        List list = fs.getFilterFieldMetaData();
        Assert.assertThat((Object)list.size(), (Matcher)CoreMatchers.is((Object)2));
        Assert.assertThat((Object)((FilterFieldMetaData)list.get(0)).getOrder(), (Matcher)CoreMatchers.is((Object)100));
        Assert.assertThat((Object)((FilterFieldMetaData)list.get(1)).getOrder(), (Matcher)CoreMatchers.is((Object)200));
    }

    @Test
    public void createFilterChoiceMetaData() throws Exception {
        FilterManager fs = new FilterManager(FilteredChoiceTestLine.class, Arrays.asList(new FilterTestManager()));
        List list = fs.getFilterFieldMetaData();
        Assert.assertThat((Object)list.size(), (Matcher)CoreMatchers.is((Object)3));
        Assert.assertThat((Object)((FilterFieldMetaData)list.get(0)).getOrder(), (Matcher)CoreMatchers.is((Object)100));
        Assert.assertThat((Object)((FilterFieldMetaData)list.get(1)).getOrder(), (Matcher)CoreMatchers.is((Object)200));
        Assert.assertThat((Object)((FilterFieldMetaData)list.get(2)).getOrder(), (Matcher)CoreMatchers.is((Object)300));
    }

    @Test
    public void filterTest() {
        FilterManager fs = new FilterManager(FilteredChoiceTestLine.class, Arrays.asList(new FilterTestManager()));
        List metaData = fs.getFilterFieldMetaData();
        fs.addExpression(((FilterFieldMetaData)metaData.get(0)).createFilterExpression(FilterOperand.GT, (Object)new BigDecimal("1000")));
        List filteredLines = (List)fs.filter(this.lines);
        Assert.assertThat((Object)filteredLines.size(), (Matcher)CoreMatchers.is((Object)2));
        fs.addExpression(((FilterFieldMetaData)metaData.get(2)).createFilterExpression(FilterOperand.EQ, (Object)"MPE"));
        filteredLines = (List)fs.filter(this.lines);
        Assert.assertThat((Object)filteredLines.size(), (Matcher)CoreMatchers.is((Object)1));
        Assert.assertThat((Object)((FilteredChoiceTestLine)filteredLines.get(0)).getYadda(), (Matcher)CoreMatchers.is((Object)"MPE"));
    }

    public class FilterTestManager {
        @FilterChoice(value="YADDAS")
        public List<String> choiceYadda() {
            return Arrays.asList("MPE", "JSC");
        }
    }

    public class FilteredChoiceTestLine {
        private BigDecimal foo;
        private Date bar;
        private String yadda;

        public FilteredChoiceTestLine(BigDecimal aFoo, Date aBar, String aYadda) {
            this.foo = aFoo;
            this.bar = aBar;
            this.yadda = aYadda;
        }

        @FilterField(order=200, displayName="Bar")
        public Date getBar() {
            return this.bar;
        }

        @FilterField(order=100, displayName="Foo")
        public BigDecimal getFoo() {
            return this.foo;
        }

        @FilterChoiceField(order=300, displayName="Yadda", sourceName="YADDAS")
        public String getYadda() {
            return this.yadda;
        }
    }

    public class FilteredTestLine {
        private BigDecimal foo;
        private Date bar;

        public FilteredTestLine(BigDecimal aFoo, Date aBar) {
            this.foo = aFoo;
            this.bar = aBar;
        }

        @FilterField(order=200, displayName="Bar")
        public Date getBar() {
            return this.bar;
        }

        @FilterField(order=100, displayName="Foo")
        public BigDecimal getFoo() {
            return this.foo;
        }
    }
}

