/*
 * Decompiled with CFR 0.152.
 */
package de.openknowledge.util.dge.filter.web;

import de.openknowledge.util.dge.filter.FilterChoiceFieldMetaData;
import de.openknowledge.util.dge.filter.FilterExpression;
import de.openknowledge.util.dge.filter.FilterFieldMetaData;
import de.openknowledge.util.dge.filter.FilterFieldType;
import de.openknowledge.util.dge.filter.FilterManager;
import de.openknowledge.util.dge.filter.FilterOperand;
import java.io.Serializable;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang.Validate;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class FilterAssembler<T extends Collection>
implements Serializable {
    private static final long serialVersionUID = -4108166213555175328L;
    private static final Log LOG = LogFactory.getLog(FilterAssembler.class);
    private boolean filterActive = false;
    private List<FilterOperand> possibleOperands = Arrays.asList(FilterOperand.values());
    private List<FilterRow> filterRows;
    private Class<?> filterLine;
    private List<Object> filterChoiceHolders = new ArrayList<Object>();
    private transient FilterManager filterManager;

    public FilterAssembler(Class<?> aFilterLine) {
        Validate.notNull(aFilterLine);
        this.filterLine = aFilterLine;
        this.resetFilter();
    }

    public FilterAssembler(Class<?> aFilterLine, Object ... theChoiceHolders) {
        Validate.notNull(aFilterLine);
        Validate.notNull((Object)theChoiceHolders);
        this.filterChoiceHolders = Arrays.asList(theChoiceHolders);
        this.filterLine = aFilterLine;
        this.resetFilter();
    }

    public Collection filter(Collection collection) {
        this.getFilterManager().resetExpressions();
        for (FilterRow row : this.filterRows) {
            FilterExpression fe = row.asExpression();
            if (fe != null) {
                LOG.info((Object)("Adding FilterExpression '" + fe + "' to filterManager."));
                this.getFilterManager().addExpression(fe);
                continue;
            }
            LOG.info((Object)("FilterRow  '" + row + "' is not a valid FilterExpression."));
        }
        LOG.info((Object)("FilterManager contains " + this.getFilterManager().getExpressions().size() + " FilterExpressions."));
        return this.getFilterManager().filter(collection);
    }

    protected FilterFieldMetaData getMetaDataByString(String methodName) {
        Validate.notNull((Object)methodName, (String)"The methodName should not be null");
        LOG.info((Object)("Searching for method with name '" + methodName + "'"));
        for (FilterFieldMetaData data : this.getFilterFieldMetaData()) {
            if (!data.getTargetMethod().getName().equals(methodName)) continue;
            LOG.info((Object)("Method found for name '" + methodName + "'"));
            return data;
        }
        LOG.info((Object)("No method was found for name '" + methodName + "'"));
        return null;
    }

    public List<FilterFieldMetaData> getFilterFieldMetaData() {
        return this.getFilterManager().getFilterFieldMetaData();
    }

    public List<FilterRow> getFilterRows() {
        return this.filterRows;
    }

    public List<FilterOperand> getPossibleOperands() {
        return this.possibleOperands;
    }

    public void removeFilterRow(FilterRow row) {
        this.filterRows.remove(row);
        if (this.filterRows.isEmpty()) {
            this.filterRows.add(new FilterRow());
        }
    }

    public void addNewFilterRow() {
        this.filterRows.add(new FilterRow());
    }

    public void resetFilter() {
        this.filterRows = new ArrayList<FilterRow>();
        this.filterRows.add(new FilterRow());
        this.getFilterManager().resetExpressions();
        LOG.info((Object)"Filter has been reset.");
    }

    protected FilterManager getFilterManager() {
        if (this.filterManager == null) {
            this.filterManager = new FilterManager(this.filterLine, this.filterChoiceHolders);
        }
        return this.filterManager;
    }

    public boolean isFilterActive() {
        return this.filterActive;
    }

    public void setFilterActive(boolean aFilterActive) {
        this.filterActive = aFilterActive;
        if (!this.filterActive) {
            this.resetFilter();
        }
    }

    public void activateFilter() {
        this.setFilterActive(true);
    }

    public void deactivateFilter() {
        this.setFilterActive(false);
    }

    public class FilterRow
    implements Serializable {
        private static final long serialVersionUID = -9079360861380466493L;
        private String methodName;
        private transient FilterFieldMetaData metaData;
        private FilterOperand filterOperand;
        private Object selection;
        private Date date;
        private BigDecimal bigDecimal;

        public FilterOperand getFilterOperand() {
            return this.filterOperand;
        }

        public FilterExpression asExpression() {
            if (this.isValid()) {
                return new FilterExpression<Comparable>(this.getMetaData(), this.filterOperand, this.getValue());
            }
            return null;
        }

        private Comparable getValue() {
            switch (this.metaData.getType()) {
                case BIGDECIMAL: {
                    return this.bigDecimal;
                }
                case DATE: {
                    return this.date;
                }
                case SELECT: {
                    return (Comparable)this.selection;
                }
            }
            throw new IllegalArgumentException("Type not supported: " + (Object)((Object)this.getMetaData().getType()));
        }

        public boolean isValid() {
            if (this.getMetaData() == null) {
                return false;
            }
            if (this.filterOperand == null) {
                return false;
            }
            return this.getValue() != null;
        }

        public Collection getChoiceValues() {
            if (this.getMetaData() instanceof FilterChoiceFieldMetaData) {
                for (Object o : FilterAssembler.this.filterChoiceHolders) {
                    try {
                        return (Collection)((FilterChoiceFieldMetaData)this.getMetaData()).getChoiceValues(o);
                    }
                    catch (RuntimeException runtimeException) {
                    }
                }
            }
            return new ArrayList();
        }

        protected Object getObjectByString(String s) {
            for (Object o : this.getChoiceValues()) {
                if (!o.toString().equals(s)) continue;
                return o;
            }
            return null;
        }

        public void setFilterOperand(FilterOperand aFilterOperand) {
            this.filterOperand = aFilterOperand;
        }

        public void setStringFilterOperand(String aFilterOperand) {
            if (StringUtils.isEmpty((String)aFilterOperand)) {
                aFilterOperand = "EQ";
            }
            this.setFilterOperand(FilterOperand.valueOf(aFilterOperand));
        }

        public String getStringFilterOperand() {
            if (this.filterOperand == null) {
                return "";
            }
            return this.filterOperand.toString();
        }

        public String getSelection() {
            if (this.selection != null) {
                return this.selection.toString();
            }
            return null;
        }

        public void setSelection(String aSelection) {
            this.selection = this.getObjectByString(aSelection);
        }

        public BigDecimal getBigDecimal() {
            return this.bigDecimal;
        }

        public void setBigDecimal(BigDecimal aBigDecimal) {
            this.bigDecimal = aBigDecimal;
        }

        public String getMethodName() {
            if (this.getMetaData() != null) {
                return this.getMetaData().getTargetMethod().getName();
            }
            return null;
        }

        public void setMethodName(String aMethodName) {
            this.methodName = aMethodName;
            this.selection = null;
            this.date = null;
            this.bigDecimal = null;
            this.metaData = null;
            this.filterOperand = null;
        }

        public FilterFieldType getFilterFieldType() {
            if (this.getMetaData() != null) {
                return this.getMetaData().getType();
            }
            return null;
        }

        public void setFilterFieldType(FilterFieldType type) {
        }

        public Date getDate() {
            if (this.date != null) {
                return new Date(this.date.getTime());
            }
            return null;
        }

        public void setDate(Date aDate) {
            this.date = aDate;
        }

        protected FilterFieldMetaData getMetaData() {
            if (this.metaData == null && this.methodName != null) {
                this.metaData = FilterAssembler.this.getMetaDataByString(this.methodName);
                if (this.metaData != null && this.metaData instanceof FilterChoiceFieldMetaData) {
                    this.filterOperand = FilterOperand.EQ;
                }
            }
            return this.metaData;
        }
    }
}

