/*
 * Decompiled with CFR 0.152.
 */
package etm.demo.webapp.javaee.domain.user;

import etm.demo.webapp.javaee.core.qualifier.Registered;
import etm.demo.webapp.javaee.core.stereotype.Service;
import etm.demo.webapp.javaee.domain.user.User;
import etm.demo.webapp.javaee.domain.user.UserRepository;
import java.io.Serializable;
import javax.enterprise.event.Event;
import javax.inject.Inject;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Service
public class UserManagementService
implements Serializable {
    private UserRepository userRepository;
    private Event<User> eventSource;

    protected UserManagementService() {
    }

    @Inject
    public UserManagementService(UserRepository aUserRepository, @Registered Event<User> aUserSource) {
        this.userRepository = aUserRepository;
        this.eventSource = aUserSource;
    }

    public User authenticate(String username, String password) {
        return this.userRepository.findUser(username, password);
    }

    public User create(String firstName, String lastname, String username, String password, String email) {
        User user = new User();
        user.setFirstName(firstName);
        user.setLastName(lastname);
        user.setUserName(username);
        user.setPassword(password);
        user.setEmail(email);
        User newUser = this.userRepository.create(user);
        this.eventSource.fire((Object)newUser);
        return newUser;
    }

    public boolean isUnusedUserName(String userName) {
        return !this.userRepository.hasUserWithUsername(userName);
    }
}

