/*
 * Decompiled with CFR 0.152.
 */
package etm.contrib.console;

import etm.contrib.console.ConsoleRequest;
import etm.contrib.console.ConsoleResponse;
import etm.contrib.console.standalone.StandaloneConsoleRequest;
import etm.contrib.console.util.CollapsedResultRenderer;
import etm.contrib.util.ExecutionAggregateComparator;
import etm.core.monitor.EtmMonitor;
import etm.core.renderer.MeasurementRenderer;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.net.InetAddress;
import java.net.Socket;
import java.util.Map;
import junit.framework.TestCase;

public abstract class ConsoleTests
extends TestCase {
    protected EtmMonitor monitor;

    public void testResultRendering() throws Exception {
        String serverResponse = this.executeRequest("/index");
        final ByteArrayOutputStream out = new ByteArrayOutputStream();
        StandaloneConsoleRequest request = new StandaloneConsoleRequest(this.monitor);
        ConsoleResponse testResponse = new ConsoleResponse(){
            OutputStreamWriter writer;
            {
                this.writer = new OutputStreamWriter(out);
            }

            public void addHeader(String header, String value) {
            }

            public void write(String content) throws IOException {
                this.writer.write(content);
                this.writer.flush();
            }

            public void write(char[] content) throws IOException {
                this.writer.write(content);
                this.writer.flush();
            }

            public void write(byte[] content) throws IOException {
                out.write(content);
            }

            public void sendRedirect(String target, Map parameters) {
            }

            public void sendStatus(int statusCode, String description) {
            }
        };
        CollapsedResultRenderer renderer = new CollapsedResultRenderer((ConsoleRequest)request, testResponse, new ExecutionAggregateComparator(3, true));
        this.monitor.render((MeasurementRenderer)renderer);
        String expected = new String(out.toByteArray(), "UTF-8");
        String response = serverResponse.substring(serverResponse.indexOf("close") + 5).trim();
        ConsoleTests.assertEquals((String)expected.substring(expected.indexOf("Begin results")), (String)response.substring(response.indexOf("Begin results")));
    }

    public void testMonitorReset() throws Exception {
        this.executeRequest("/reset");
        this.monitor.render(new MeasurementRenderer(){

            public void render(Map points) {
                TestCase.assertEquals((int)0, (int)points.size());
            }
        });
    }

    public void testCollectionStop() throws Exception {
        this.executeRequest("/stop");
        ConsoleTests.assertFalse((boolean)this.monitor.isCollecting());
    }

    public void testCollectionStart() throws Exception {
        this.monitor.disableCollection();
        this.executeRequest("/start");
        ConsoleTests.assertTrue((boolean)this.monitor.isCollecting());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected String executeRequest(String request) throws Exception {
        Socket socket = new Socket(InetAddress.getLocalHost().getHostAddress(), 40000);
        socket.setSoTimeout(30000);
        OutputStream outputStream = socket.getOutputStream();
        outputStream.write(("GET " + request + " HTTP/1.0\n").getBytes());
        outputStream.flush();
        byte[] buffer = new byte[65535];
        int pos = 0;
        InputStream in = socket.getInputStream();
        try {
            int r;
            while ((r = in.read(buffer, pos, buffer.length - pos)) > -1) {
                pos += r;
            }
        }
        finally {
            in.close();
            socket.close();
        }
        return new String(buffer, "UTF-8");
    }
}

