/*
 * Decompiled with CFR 0.152.
 */
package etm.contrib.integration.jee.jsf;

import etm.contrib.integration.jee.jsf.EtmJsfPlugin;
import etm.core.configuration.EtmManager;
import etm.core.metadata.PluginMetaData;
import etm.core.monitor.EtmMonitor;
import etm.core.monitor.EtmPoint;
import etm.core.util.Log;
import etm.core.util.LogAdapter;
import javax.faces.FacesException;
import javax.faces.application.Application;
import javax.faces.application.ApplicationFactory;
import javax.faces.application.ApplicationWrapper;
import javax.faces.component.StateHolder;
import javax.faces.component.UIComponent;
import javax.faces.context.FacesContext;
import javax.faces.convert.Converter;
import javax.faces.validator.Validator;
import javax.faces.validator.ValidatorException;

public class DelegatingEtmApplicationFactory
extends ApplicationFactory {
    private static final LogAdapter LOG = Log.getLog(DelegatingEtmApplicationFactory.class);
    private ApplicationFactory delegate;
    private Application wrappedDelegate;

    public DelegatingEtmApplicationFactory(ApplicationFactory aDelegate) {
        this.delegate = aDelegate;
        if (!this.isEnabled().booleanValue()) {
            LOG.info("JSF converter/validator monitoring disabled.");
        } else {
            LOG.debug("JSF converter/validator monitoring enabled.");
        }
    }

    public Application getApplication() {
        if (!this.isEnabled().booleanValue() || this.wrappedDelegate != null) {
            return this.delegate.getApplication();
        }
        this.wrappedDelegate = new EtmApplication(this.delegate.getApplication());
        return this.wrappedDelegate;
    }

    public void setApplication(Application application) {
        if (this.isEnabled().booleanValue()) {
            this.wrappedDelegate = new EtmApplication(application);
        }
        this.delegate.setApplication(application);
    }

    protected Boolean isEnabled() {
        String obj;
        Boolean enabled = false;
        EtmMonitor monitor = EtmManager.getEtmMonitor();
        PluginMetaData pluginMetaData = monitor.getMetaData().getPluginMetaData(EtmJsfPlugin.class);
        if (pluginMetaData != null && (obj = (String)pluginMetaData.getProperties().get("EtmJsfPlugin.converterValidatorMonitoring")) != null) {
            enabled = Boolean.parseBoolean(obj);
        }
        return enabled;
    }

    class EtmValidator
    implements Validator,
    StateHolder {
        private Validator validator;
        private String pointName;

        EtmValidator(Validator aAValidator) {
            this.validator = aAValidator;
            this.pointName = aAValidator.getClass().getSimpleName() + ":validate";
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void validate(FacesContext context, UIComponent component, Object value) throws ValidatorException {
            EtmPoint point = EtmManager.getEtmMonitor().createPoint(this.pointName);
            try {
                this.validator.validate(context, component, value);
            }
            finally {
                point.collect();
            }
        }

        public boolean isTransient() {
            return true;
        }

        public Object saveState(FacesContext context) {
            return null;
        }

        public void restoreState(FacesContext context, Object state) {
        }

        public void setTransient(boolean newTransientValue) {
        }
    }

    class EtmConverter
    implements Converter {
        private Converter converter;
        private String asObjectName;
        private String asStringName;

        EtmConverter(Converter aAConverter) {
            this.converter = aAConverter;
            this.asObjectName = aAConverter.getClass().getSimpleName() + ":getAsObject";
            this.asStringName = aAConverter.getClass().getSimpleName() + ":getAsString";
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public Object getAsObject(FacesContext context, UIComponent component, String value) {
            EtmPoint point = EtmManager.getEtmMonitor().createPoint(this.asObjectName);
            try {
                Object object = this.converter.getAsObject(context, component, value);
                return object;
            }
            finally {
                point.collect();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public String getAsString(FacesContext context, UIComponent component, Object value) {
            EtmPoint point = EtmManager.getEtmMonitor().createPoint(this.asStringName);
            try {
                String string = this.converter.getAsString(context, component, value);
                return string;
            }
            finally {
                point.collect();
            }
        }
    }

    class EtmApplication
    extends ApplicationWrapper {
        private Application wrapped;

        EtmApplication(Application aWrapped) {
            this.wrapped = aWrapped;
        }

        public Application getWrapped() {
            return this.wrapped;
        }

        public Validator createValidator(String validatorId) throws FacesException {
            Validator validator = this.getWrapped().createValidator(validatorId);
            if (validator != null) {
                return new EtmValidator(validator);
            }
            return null;
        }

        public Converter createConverter(String converterId) {
            Converter converter = this.getWrapped().createConverter(converterId);
            if (converter != null) {
                return new EtmConverter(converter);
            }
            return null;
        }
    }
}

