/*
 * Decompiled with CFR 0.152.
 */
package etm.contrib.rrd.rrd4j;

import etm.contrib.rrd.rrd4j.Rrd4jPlugin;
import etm.contrib.rrd.rrd4j.Rrd4jUtil;
import etm.core.aggregation.Aggregator;
import etm.core.aggregation.NotifyingAggregator;
import etm.core.aggregation.RootAggregator;
import etm.core.monitor.EtmPoint;
import etm.core.monitor.NestedMonitor;
import etm.core.plugin.EtmPlugin;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.PrintStream;
import java.net.URL;
import java.nio.charset.Charset;
import java.util.ArrayList;
import junit.framework.TestCase;
import org.rrd4j.core.RrdDb;

public class Rrd4jPluginTest
extends TestCase {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testMissingAggregator() {
        NestedMonitor monitor = new NestedMonitor();
        Rrd4jPlugin plugin = new Rrd4jPlugin();
        monitor.addPlugin((EtmPlugin)plugin);
        PrintStream writer = System.err;
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        PrintStream tmpErr = new PrintStream(out);
        System.setErr(tmpErr);
        try {
            monitor.start();
            tmpErr.flush();
            String s = new String(out.toByteArray(), Charset.defaultCharset());
            Rrd4jPluginTest.assertTrue((s.indexOf("NotifyingAggregator") > -1 ? 1 : 0) != 0);
        }
        finally {
            System.setErr(writer);
            monitor.stop();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testRrdDbWrite() throws Exception {
        URL resource = Thread.currentThread().getContextClassLoader().getResource("etm/contrib/rrd/rrd4j/resources/basic_db_template.xml");
        File path = File.createTempFile("test", ".rrd");
        try {
            NestedMonitor monitor = new NestedMonitor((Aggregator)new NotifyingAggregator((Aggregator)new RootAggregator()));
            try {
                path.delete();
                Rrd4jUtil rrd4jUtil = new Rrd4jUtil();
                rrd4jUtil.createRrdDb(resource, path, null);
                Rrd4jPlugin plugin = new Rrd4jPlugin();
                ArrayList<String> configurations = new ArrayList<String>();
                configurations.add(path.getName() + "!*");
                plugin.setDestinations(configurations);
                monitor.addPlugin((EtmPlugin)plugin);
                monitor.start();
                long endtime = System.currentTimeMillis() + 10000L;
                while (System.currentTimeMillis() < endtime) {
                    EtmPoint point = monitor.createPoint("testPoint");
                    try {
                        Thread.sleep(2L);
                    }
                    finally {
                        point.collect();
                    }
                }
            }
            finally {
                monitor.stop();
            }
            RrdDb db = new RrdDb(path.getAbsolutePath(), true);
            Rrd4jPluginTest.assertTrue((db.getDatasource("transactions!").getLastValue() > 0.0 ? 1 : 0) != 0);
            Rrd4jPluginTest.assertTrue((db.getDatasource("min").getLastValue() > 0.0 ? 1 : 0) != 0);
            Rrd4jPluginTest.assertTrue((db.getDatasource("max").getLastValue() > db.getDatasource("min").getLastValue() ? 1 : 0) != 0);
            Rrd4jPluginTest.assertTrue((db.getDatasource("average").getLastValue() > db.getDatasource("min").getLastValue() ? 1 : 0) != 0);
            Rrd4jPluginTest.assertTrue((db.getDatasource("max").getLastValue() > db.getDatasource("average").getLastValue() ? 1 : 0) != 0);
            db.close();
        }
        finally {
            path.delete();
        }
    }
}

