/*
 * Decompiled with CFR 0.152.
 */
package etm.contrib.integration.spring.web;

import etm.core.monitor.EtmMonitor;
import java.util.Iterator;
import java.util.Map;
import javax.servlet.ServletException;
import org.springframework.beans.BeansException;
import org.springframework.context.ApplicationContext;

public class SpringEtmMonitorContextSupport {
    public static final String ETM_MONITOR_PARAMETER_NAME = "etmMonitorName";

    public static EtmMonitor locateEtmMonitor(ApplicationContext ctx, String etmMonitorName) throws ServletException {
        if (etmMonitorName != null) {
            try {
                return (EtmMonitor)ctx.getBean(etmMonitorName);
            }
            catch (BeansException e) {
                throw new ServletException("Unable to locate EtmMonitor instance called '" + etmMonitorName + "'");
            }
        }
        Map map = ctx.getBeansOfType(EtmMonitor.class);
        if (map.size() > 0) {
            if (map.size() == 1) {
                return (EtmMonitor)map.values().iterator().next();
            }
            StringBuffer beanNames = new StringBuffer();
            Iterator iterator = map.keySet().iterator();
            while (iterator.hasNext()) {
                String beanName = (String)iterator.next();
                beanNames.append(beanName);
                beanNames.append(',');
            }
            beanNames.deleteCharAt(beanNames.length() - 1);
            throw new ServletException("Located more than one EtmMonitor instance. Please specify the name of EtmMonitor instance. [Found: " + beanNames + "]");
        }
        throw new ServletException("Unable to locate EtmMonitor instance in bean definitions.");
    }
}

